/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.part;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.silentchaos512.gear.api.data.part.PartBuilder;
import net.silentchaos512.gear.data.DataGenerators;
import org.jetbrains.annotations.NotNull;

public abstract class PartsProviderBase
implements DataProvider {
    protected final DataGenerator generator;
    protected final String modId;

    public PartsProviderBase(DataGenerator generator, String modId) {
        this.generator = generator;
        this.modId = modId;
    }

    private static void trySaveStable(CachedOutput cache, PartBuilder builder, Path path) {
        try {
            DataGenerators.saveStable(cache, (JsonElement)builder.serialize(), path);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @NotNull
    public String m_6055_() {
        return "Silent Gear Parts: " + this.modId;
    }

    protected abstract Collection<PartBuilder> getParts();

    public void m_213708_(@NotNull CachedOutput cache) {
        Path outputFolder = this.generator.m_123916_();
        HashSet entries = Sets.newHashSet();
        this.getParts().forEach(builder -> {
            if (entries.contains(builder.getId())) {
                throw new IllegalStateException("Duplicate part: " + builder.getId());
            }
            entries.add(builder.getId());
            Path path = outputFolder.resolve(String.format("data/%s/silentgear_parts/%s.json", builder.getId().m_135827_(), builder.getId().m_135815_()));
            PartsProviderBase.trySaveStable(cache, builder, path);
        });
    }
}

