/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.silentchaos512.treasurebags.lib.BagType;
import net.silentchaos512.treasurebags.lib.BagTypeManager;
import net.silentchaos512.treasurebags.lib.IBagType;

public class SyncBagTypesPacket {
    private List<IBagType> types;

    public SyncBagTypesPacket() {
        this(BagTypeManager.getValues());
    }

    public SyncBagTypesPacket(Collection<IBagType> types) {
        this.types = new ArrayList<IBagType>(types);
    }

    public static SyncBagTypesPacket fromBytes(FriendlyByteBuf buffer) {
        SyncBagTypesPacket packet = new SyncBagTypesPacket();
        packet.types = new ArrayList<IBagType>();
        int count = buffer.m_130242_();
        for (int i = 0; i < count; ++i) {
            packet.types.add(BagType.Serializer.read(buffer));
        }
        return packet;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.types.size());
        this.types.forEach(type -> BagType.Serializer.write(type, buffer));
    }

    public List<IBagType> getBagTypes() {
        return this.types;
    }
}

