/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.silentchaos512.treasurebags.item.TreasureBagItem;
import net.silentchaos512.treasurebags.setup.TbLoot;

public final class SetBagTypeFunction
extends LootItemConditionalFunction {
    private final ResourceLocation typeId;

    private SetBagTypeFunction(ResourceLocation typeId, LootItemCondition[] conditionsIn) {
        super(conditionsIn);
        this.typeId = typeId;
    }

    public static LootItemConditionalFunction.Builder builder(final ResourceLocation bagTypeId, final LootItemCondition ... conditions) {
        return new LootItemConditionalFunction.Builder(){

            protected LootItemConditionalFunction.Builder m_6477_() {
                return this;
            }

            public LootItemFunction m_7453_() {
                return new SetBagTypeFunction(bagTypeId, conditions);
            }
        };
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        return TreasureBagItem.setBagType(stack, this.typeId);
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)TbLoot.SET_BAG_TYPE.get();
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetBagTypeFunction> {
        public void serialize(JsonObject json, SetBagTypeFunction function, JsonSerializationContext serializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)function, serializationContext);
            json.addProperty("type", function.typeId.toString());
        }

        public SetBagTypeFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            String str = GsonHelper.m_13851_((JsonObject)object, (String)"type", (String)"");
            ResourceLocation id = ResourceLocation.m_135820_((String)str);
            if (id == null) {
                throw new JsonParseException("Bag type is invalid or missing: '" + str + "'");
            }
            return new SetBagTypeFunction(id, conditionsIn);
        }
    }
}

