/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.item.TreasureBagItem;
import net.silentchaos512.treasurebags.lib.BagType;
import net.silentchaos512.treasurebags.lib.BagTypeManager;
import net.silentchaos512.treasurebags.lib.IBagType;
import net.silentchaos512.treasurebags.setup.TbLoot;

public class SelectBagRarity
extends LootItemConditionalFunction {
    private final Rarity rarity;

    public SelectBagRarity(Rarity rarity, LootItemCondition[] conditions) {
        super(conditions);
        this.rarity = rarity;
    }

    public static LootItemConditionalFunction.Builder builder(final Rarity rarity, final LootItemCondition ... conditions) {
        return new LootItemConditionalFunction.Builder(){

            protected LootItemConditionalFunction.Builder m_6477_() {
                return this;
            }

            public LootItemFunction m_7453_() {
                return new SelectBagRarity(rarity, conditions);
            }
        };
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (entity == null) {
            return ItemStack.f_41583_;
        }
        List<IBagType> list = BagTypeManager.getValues().stream().filter(type -> type.canDropFromMob(entity) && type.getRarity() == this.rarity).toList();
        if (list.isEmpty()) {
            return ItemStack.f_41583_;
        }
        IBagType bagType = list.get(TreasureBags.RANDOM.nextInt(list.size()));
        return TreasureBagItem.setBagType(stack, bagType.getId());
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)TbLoot.SELECT_BAG_RARITY.get();
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SelectBagRarity> {
        public void serialize(JsonObject json, SelectBagRarity function, JsonSerializationContext serializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)function, serializationContext);
            json.addProperty("rarity", function.rarity.name().toLowerCase(Locale.ROOT));
        }

        public SelectBagRarity deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            Rarity rarity = BagType.Serializer.deserializeRarity(GsonHelper.m_13906_((JsonObject)json, (String)"rarity"));
            return new SelectBagRarity(rarity, conditionsIn);
        }
    }
}

