/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.lib;

import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.api.IEntityGroup;

public enum StandardEntityGroups implements IEntityGroup
{
    PLAYER(e -> e instanceof Player),
    BOSS(e -> !e.m_6072_()),
    HOSTILE(e -> e instanceof Enemy),
    PEACEFUL(e -> !(e instanceof Player) && e.m_6072_() && !(e instanceof Enemy));

    private final ResourceLocation lootTable = TreasureBags.getId("entity_group/" + this.getName());
    private final Predicate<Entity> predicate;

    private StandardEntityGroups(Predicate<Entity> predicate) {
        this.predicate = predicate;
    }

    @Override
    public ResourceLocation getId() {
        return TreasureBags.getId(this.getName());
    }

    @Override
    public boolean matches(Entity entity) {
        return this.predicate.test(entity);
    }

    @Override
    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

