/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.lib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.config.Config;
import net.silentchaos512.treasurebags.item.TreasureBagItem;
import net.silentchaos512.treasurebags.lib.BagType;
import net.silentchaos512.treasurebags.lib.IBagType;
import net.silentchaos512.treasurebags.network.SyncBagTypesPacket;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class BagTypeManager
implements ResourceManagerReloadListener {
    public static final BagTypeManager INSTANCE = new BagTypeManager();
    private static final Marker MARKER = MarkerManager.getMarker((String)"BagTypeManager");
    private static final String RESOURCES_PATH = "treasurebags_types";
    private static final Map<ResourceLocation, IBagType> MAP = new LinkedHashMap<ResourceLocation, IBagType>();
    private static final Collection<ResourceLocation> ERROR_LIST = new ArrayList<ResourceLocation>();

    private BagTypeManager() {
    }

    @Nullable
    public static IBagType getValue(ResourceLocation id) {
        return MAP.get(id);
    }

    public static Collection<IBagType> getValues() {
        return MAP.values();
    }

    @Nullable
    public static IBagType typeFromBag(ItemStack stack) {
        if (!(stack.m_41720_() instanceof TreasureBagItem)) {
            return null;
        }
        return TreasureBagItem.getBagType(stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6213_(ResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Map resources = resourceManager.m_214159_(RESOURCES_PATH, s -> s.toString().endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        MAP.clear();
        ERROR_LIST.clear();
        TreasureBags.LOGGER.info(MARKER, "Reloading bag type files");
        Map<ResourceLocation, IBagType> map = MAP;
        synchronized (map) {
            for (ResourceLocation id : resources.keySet()) {
                String path = id.m_135815_().substring(RESOURCES_PATH.length() + 1, id.m_135815_().length() - ".json".length());
                ResourceLocation name = new ResourceLocation(id.m_135827_(), path);
                Optional resourceOptional = resourceManager.m_213713_(id);
                if (!resourceOptional.isPresent()) continue;
                Resource iresource = (Resource)resourceOptional.get();
                if (TreasureBags.LOGGER.isTraceEnabled()) {
                    TreasureBags.LOGGER.trace(MARKER, "Found bag type file: {}, reading as '{}'", (Object)id, (Object)name);
                }
                JsonObject json = null;
                try {
                    json = (JsonObject)GsonHelper.m_13794_((Gson)gson, (String)IOUtils.toString((InputStream)iresource.m_215507_(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                }
                catch (IOException ex) {
                    TreasureBags.LOGGER.error("Could not read bag type {}", (Object)name);
                    TreasureBags.LOGGER.error((Object)ex);
                    ERROR_LIST.add(name);
                }
                if (json == null) continue;
                IBagType type = BagTypeManager.deserialize(name, json);
                if (!((List)Config.Common.disabledBagGroups.get()).contains(type.getGroup())) {
                    BagTypeManager.addBagType(type);
                    continue;
                }
                TreasureBags.LOGGER.debug("Skipping bag type \"{}\" as its group (\"{}\") is disabled in the config", (Object)type.getId(), (Object)type.getGroup());
            }
        }
    }

    private static void addBagType(IBagType type) {
        MAP.put(type.getId(), type);
    }

    private static IBagType deserialize(ResourceLocation name, JsonObject json) {
        return BagType.Serializer.deserialize(name, json);
    }

    public static void handleSyncPacket(SyncBagTypesPacket packet, Supplier<NetworkEvent.Context> context) {
        MAP.clear();
        packet.getBagTypes().forEach(type -> MAP.put(type.getId(), (IBagType)type));
        TreasureBags.LOGGER.info("Read {} bag types from server", (Object)MAP.size());
        context.get().setPacketHandled(true);
    }

    public static Collection<Component> getErrorMessages(ServerPlayer player) {
        int missingLootTables;
        ArrayList<Component> messages = new ArrayList<Component>();
        if (!ERROR_LIST.isEmpty()) {
            String listStr = ERROR_LIST.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
            messages.add(BagTypeManager.errorMessage("The following bag types failed to load, check your log file:"));
            messages.add((Component)Component.m_237113_((String)listStr));
        }
        if ((missingLootTables = BagTypeManager.countMissingLootTables(player)) > 0) {
            Object counter = missingLootTables == 1 ? "1 bag type has a missing or invalid loot table" : missingLootTables + " bag types have missing or invalid loot tables";
            messages.add(BagTypeManager.errorMessage((String)counter));
        }
        return messages;
    }

    private static int countMissingLootTables(ServerPlayer player) {
        MinecraftServer server = player.f_19853_.m_7654_();
        if (server == null) {
            return 0;
        }
        Set lootTables = server.m_129898_().m_79195_();
        return (int)MAP.values().stream().filter(bagType -> !lootTables.contains(bagType.getLootTable())).count();
    }

    private static Component errorMessage(String str) {
        return Component.m_237113_((String)"[Treasure Bags] ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)Component.m_237113_((String)str).m_130940_(ChatFormatting.WHITE));
    }
}

