/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.lib;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Rarity;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.api.IEntityGroup;
import net.silentchaos512.treasurebags.lib.IBagType;
import net.silentchaos512.treasurebags.lib.TagEntityGroup;
import net.silentchaos512.treasurebags.setup.EntityGroups;
import net.silentchaos512.utils.Color;

public final class BagType
implements IBagType {
    private final ResourceLocation name;
    private String group = "none";
    private Rarity rarity;
    private final Collection<IEntityGroup> dropsFromGroups = new HashSet<IEntityGroup>();
    private int bagColor;
    private int bagOverlayColor;
    private int bagStringColor;
    private Component customName;
    private ResourceLocation lootTable;
    private boolean visible;

    private BagType(ResourceLocation name) {
        this.name = name;
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    @Override
    public boolean canDropFromMob(Entity entity) {
        for (IEntityGroup group : this.dropsFromGroups) {
            if (!group.matches(entity)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getBagColor() {
        return this.bagColor;
    }

    @Override
    public int getBagOverlayColor() {
        return this.bagOverlayColor;
    }

    @Override
    public int getBagStringColor() {
        return this.bagStringColor;
    }

    @Override
    public Component getCustomName() {
        return this.customName;
    }

    @Override
    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public static final class Serializer {
        private Serializer() {
        }

        public static BagType deserialize(ResourceLocation name, JsonObject json) {
            BagType result = new BagType(name);
            String tableName = GsonHelper.m_13906_((JsonObject)json, (String)"lootTable");
            ResourceLocation lootTable = ResourceLocation.m_135820_((String)tableName);
            if (lootTable == null) {
                throw new JsonParseException("Invalid loot table: " + tableName);
            }
            result.lootTable = lootTable;
            result.rarity = Serializer.deserializeRarity(GsonHelper.m_13906_((JsonObject)json, (String)"rarity"));
            result.customName = Component.Serializer.m_130691_((JsonElement)json.get("displayName"));
            result.bagColor = Color.from((JsonObject)json, (String)"bagColor", (int)0xFFFFFF).getColor();
            result.bagOverlayColor = Color.from((JsonObject)json, (String)"bagOverlayColor", (int)0xFFFFFF).getColor();
            result.bagStringColor = Color.from((JsonObject)json, (String)"bagStringColor", (int)0xFFFFFF).getColor();
            result.visible = GsonHelper.m_13855_((JsonObject)json, (String)"visible", (boolean)true);
            result.group = GsonHelper.m_13906_((JsonObject)json, (String)"group");
            JsonElement dropsFromJson = json.get("dropsFromGroups");
            if (dropsFromJson != null && dropsFromJson.isJsonArray()) {
                JsonArray array = dropsFromJson.getAsJsonArray();
                for (JsonElement e : array) {
                    ResourceLocation id = TreasureBags.getIdWithDefaultNamespace(e.getAsString());
                    if (id != null) {
                        IEntityGroup group = EntityGroups.getOrCreate(id, Serializer::getOrCreateEntityGroup);
                        result.dropsFromGroups.add(group);
                        continue;
                    }
                    throw new JsonParseException("Invalid entity group name: " + e.getAsString());
                }
            }
            return result;
        }

        public static BagType read(FriendlyByteBuf buffer) {
            BagType bagType = new BagType(buffer.m_130281_());
            bagType.lootTable = buffer.m_130281_();
            bagType.rarity = (Rarity)buffer.m_130066_(Rarity.class);
            bagType.customName = buffer.m_130238_();
            bagType.bagColor = buffer.m_130242_();
            bagType.bagOverlayColor = buffer.m_130242_();
            bagType.bagStringColor = buffer.m_130242_();
            bagType.visible = buffer.readBoolean();
            int groupsCount = buffer.readByte();
            for (int i = 0; i < groupsCount; ++i) {
                bagType.dropsFromGroups.add(EntityGroups.getOrCreate(buffer.m_130281_(), Serializer::getOrCreateEntityGroup));
            }
            return bagType;
        }

        public static void write(IBagType bagType, FriendlyByteBuf buffer) {
            buffer.m_130085_(bagType.getId());
            buffer.m_130085_(bagType.getLootTable());
            buffer.m_130068_((Enum)bagType.getRarity());
            buffer.m_130083_(bagType.getCustomName());
            buffer.m_130130_(bagType.getBagColor());
            buffer.m_130130_(bagType.getBagOverlayColor());
            buffer.m_130130_(bagType.getBagStringColor());
            buffer.writeBoolean(bagType.isVisible());
            if (bagType instanceof BagType) {
                Collection<IEntityGroup> groups = ((BagType)bagType).dropsFromGroups;
                buffer.writeByte(groups.size());
                groups.forEach(group -> buffer.m_130085_(group.getId()));
            }
        }

        public static Rarity deserializeRarity(String name) {
            for (Rarity rarity : Rarity.values()) {
                if (!name.equalsIgnoreCase(rarity.name())) continue;
                return rarity;
            }
            throw new JsonSyntaxException("Unknown rarity: " + name);
        }

        private static IEntityGroup getOrCreateEntityGroup(ResourceLocation id) {
            return new TagEntityGroup(id, TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)id));
        }
    }
}

