/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import net.silentchaos512.lib.item.LootContainerItem;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.config.Config;
import net.silentchaos512.treasurebags.lib.BagTypeManager;
import net.silentchaos512.treasurebags.lib.IBagType;

public class TreasureBagItem
extends LootContainerItem {
    private static final String NBT_BAG_TYPE = "BagType";

    public TreasureBagItem(Item.Properties properties) {
        super(TreasureBags.getId("default_bag"), true, properties);
    }

    public ItemStack stackOfType(IBagType type) {
        return this.stackOfType(type, 1);
    }

    public ItemStack stackOfType(IBagType type, int count) {
        ItemStack result = new ItemStack((ItemLike)this, count);
        return TreasureBagItem.setBagProperties(result, type);
    }

    public ItemStack stackOfType(ResourceLocation typeName) {
        ItemStack result = new ItemStack((ItemLike)this);
        return TreasureBagItem.setBagType(result, typeName);
    }

    @Nullable
    public static IBagType getBagType(ItemStack stack) {
        String typeStr = TreasureBagItem.getBagTypeString(stack);
        return BagTypeManager.getValue(new ResourceLocation(typeStr));
    }

    private static String getBagTypeString(ItemStack stack) {
        return TreasureBagItem.getData((ItemStack)stack).m_128461_(NBT_BAG_TYPE);
    }

    public static ItemStack setBagType(ItemStack stack, ResourceLocation bagTypeId) {
        if (!(stack.m_41720_() instanceof TreasureBagItem)) {
            return stack;
        }
        CompoundTag tag = TreasureBagItem.getData((ItemStack)stack);
        tag.m_128359_(NBT_BAG_TYPE, bagTypeId.toString());
        return stack;
    }

    public static ItemStack setBagProperties(ItemStack stack, IBagType type) {
        if (!(stack.m_41720_() instanceof TreasureBagItem)) {
            return stack;
        }
        CompoundTag tag = TreasureBagItem.getData((ItemStack)stack);
        tag.m_128359_(NBT_BAG_TYPE, type.getId().toString());
        TreasureBagItem.setLootTable((ItemStack)stack, (ResourceLocation)type.getLootTable());
        return stack;
    }

    @Nonnull
    protected ResourceLocation getLootTable(ItemStack stack) {
        IBagType type = TreasureBagItem.getBagType(stack);
        if (type == null) {
            return super.getLootTable(stack);
        }
        return type.getLootTable();
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        IBagType type = TreasureBagItem.getBagType(stack);
        if (type != null) {
            return type.getCustomName();
        }
        return super.m_7626_(stack);
    }

    public Rarity m_41460_(ItemStack stack) {
        IBagType type = TreasureBagItem.getBagType(stack);
        if (type != null) {
            return type.getRarity();
        }
        return super.m_41460_(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(ItemStack stack, int tintIndex) {
        IBagType bagType = TreasureBagItem.getBagType(stack);
        if (bagType != null) {
            if (tintIndex == 0) {
                return bagType.getBagColor();
            }
            if (tintIndex == 1) {
                return bagType.getBagOverlayColor();
            }
            if (tintIndex == 2) {
                return bagType.getBagStringColor();
            }
        }
        return 0xFFFFFF;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, TooltipFlag flagIn) {
        if (flagIn.m_7050_()) {
            IBagType type = TreasureBagItem.getBagType(stack);
            if (type != null) {
                tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".type"), (Object[])new Object[]{type.getId()}).m_130940_(ChatFormatting.YELLOW));
            } else {
                String typeStr = TreasureBagItem.getBagTypeString(stack);
                tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".unknownType")).m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".type"), (Object[])new Object[]{typeStr}).m_130940_(ChatFormatting.YELLOW));
            }
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        String typeStr = TreasureBagItem.getBagTypeString(stack);
        ResourceLocation typeName = ResourceLocation.m_135820_((String)typeStr);
        if (typeName != null) {
            tooltip.add((Component)Component.m_237113_((String)typeName.m_135827_()).m_130940_(ChatFormatting.BLUE).m_130940_(ChatFormatting.ITALIC));
        } else {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".invalidType")).m_130940_(ChatFormatting.RED));
        }
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (!this.m_220152_(group)) {
            return;
        }
        items.add((Object)new ItemStack((ItemLike)this));
        ArrayList<IBagType> list = new ArrayList<IBagType>(BagTypeManager.getValues());
        list.sort(Comparator.comparing(o -> o.getId().toString()));
        for (IBagType type : list) {
            if (!type.isVisible()) continue;
            items.add((Object)this.stackOfType(type));
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack heldItem = playerIn.m_21120_(handIn);
        if (!(playerIn instanceof ServerPlayer)) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
        }
        ServerPlayer playerMP = (ServerPlayer)playerIn;
        boolean openWholeStack = playerMP.m_6047_();
        Collection<ItemStack> lootDrops = this.getDropsFromStack(heldItem, playerMP, openWholeStack);
        if (lootDrops.isEmpty()) {
            TreasureBags.LOGGER.warn("No drops from bag, is the loot table valid? {}, table={}", (Object)heldItem, (Object)this.getLootTable(heldItem));
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)heldItem);
        }
        lootDrops.forEach(stack -> {
            this.giveOrDropItem(playerIn, stack.m_41777_());
            TreasureBagItem.listItemReceivedInChat(playerMP, stack);
        });
        playerMP.f_19853_.m_6263_(null, playerMP.m_20185_(), playerMP.m_20186_(), playerMP.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((playerMP.m_217043_().m_188501_() - playerMP.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
        heldItem.m_41774_(openWholeStack ? heldItem.m_41613_() : 1);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldItem);
    }

    private void giveOrDropItem(Player playerIn, ItemStack copy) {
        if (((Boolean)Config.Common.alwaysSpawnItems.get()).booleanValue() || !playerIn.m_150109_().m_36054_(copy)) {
            ItemEntity entityItem = new ItemEntity(playerIn.f_19853_, playerIn.m_20185_(), playerIn.m_20227_(0.5), playerIn.m_20189_(), copy);
            entityItem.m_32061_();
            entityItem.m_32047_(playerIn.m_20148_());
            playerIn.f_19853_.m_7967_((Entity)entityItem);
        }
    }

    private Collection<ItemStack> getDropsFromStack(ItemStack stack, ServerPlayer player, boolean wholeStack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int openCount = wholeStack ? stack.m_41613_() : 1;
        for (int i = 0; i < openCount; ++i) {
            this.getLootDrops(stack, player).forEach(s -> TreasureBagItem.mergeItem(list, s));
        }
        return list;
    }

    private static void mergeItem(Collection<ItemStack> list, ItemStack stack) {
        for (ItemStack itemStack : list) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)itemStack, (ItemStack)stack)) continue;
            int space = itemStack.m_41741_() - itemStack.m_41613_();
            int toMerge = Math.min(space, stack.m_41613_());
            itemStack.m_41769_(toMerge);
            stack.m_41774_(toMerge);
            if (!stack.m_41619_()) continue;
            return;
        }
        if (!stack.m_41619_()) {
            list.add(stack);
        }
    }

    private static void listItemReceivedInChat(ServerPlayer playerMP, ItemStack stack) {
        MutableComponent itemReceivedText = Component.m_237110_((String)"item.silentlib.lootContainer.itemReceived", (Object[])new Object[]{stack.m_41613_(), stack.m_41786_()});
        playerMP.m_213846_((Component)itemReceivedText);
    }
}

