/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.events;

import java.util.Collection;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.lib.BagTypeManager;
import net.silentchaos512.treasurebags.lib.IBagType;
import net.silentchaos512.treasurebags.network.Network;
import net.silentchaos512.treasurebags.network.SyncBagTypesPacket;

@Mod.EventBusSubscriber(modid="treasurebags")
public final class ServerEvents {
    private ServerEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer playerMP = (ServerPlayer)player;
        ServerEvents.sendBagTypesToClient(playerMP);
        BagTypeManager.getErrorMessages(playerMP).forEach(arg_0 -> ((Player)player).m_213846_(arg_0));
    }

    private static void sendBagTypesToClient(ServerPlayer playerMP) {
        Collection<IBagType> bagTypes = BagTypeManager.getValues();
        TreasureBags.LOGGER.info("Sending {} bag types to {}", (Object)bagTypes.size(), (Object)playerMP.m_6302_());
        SyncBagTypesPacket msg = new SyncBagTypesPacket(bagTypes);
        Network.channel.sendTo((Object)msg, playerMP.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

