/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.events;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.treasurebags.api.IEntityGroup;
import net.silentchaos512.treasurebags.setup.EntityGroups;

@Mod.EventBusSubscriber(modid="treasurebags")
public final class EventHandler {
    private EventHandler() {
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Level world = entity.f_19853_;
        if (world.f_46443_) {
            return;
        }
        MinecraftServer server = world.m_7654_();
        if (server == null) {
            return;
        }
        if (!world.m_46469_().m_46207_(GameRules.f_46135_)) {
            return;
        }
        Player player = EventHandler.getPlayerThatCausedDeath(event.getSource());
        EntityGroups.getGroups((Entity)entity).forEach(group -> EventHandler.doDropsForGroup(event, entity, world, server, player, group));
    }

    private static void doDropsForGroup(LivingDropsEvent event, LivingEntity entity, Level world, MinecraftServer server, Player player, IEntityGroup group) {
        LootTable lootTable = server.m_129898_().m_79217_(group.getLootTable());
        LootContext.Builder contextBuilder = new LootContext.Builder((ServerLevel)world).m_78972_(LootContextParams.f_81455_, (Object)entity).m_78972_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_78972_(LootContextParams.f_81457_, (Object)event.getSource()).m_78984_(LootContextParams.f_81458_, (Object)player).m_78984_(LootContextParams.f_81456_, (Object)player).m_78984_(LootContextParams.f_81459_, (Object)event.getSource().m_7640_());
        if (player != null) {
            contextBuilder.m_78963_(player.m_36336_());
        }
        ObjectArrayList list = lootTable.m_230922_(contextBuilder.m_78975_(LootContextParamSets.f_81415_));
        list.forEach(stack -> event.getDrops().add(new ItemEntity(world, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack)));
    }

    @Nullable
    private static Player getPlayerThatCausedDeath(DamageSource source) {
        TamableAnimal tamed;
        if (source == null) {
            return null;
        }
        Entity entitySource = source.m_7639_();
        if (entitySource instanceof Player) {
            return (Player)entitySource;
        }
        if (entitySource instanceof TamableAnimal && (tamed = (TamableAnimal)entitySource).m_21824_() && tamed.m_21826_() instanceof Player) {
            return (Player)tamed.m_21826_();
        }
        return null;
    }
}

