/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.GiftLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.silentchaos512.treasurebags.lib.Const;
import net.silentchaos512.treasurebags.lib.StandardEntityGroups;
import net.silentchaos512.treasurebags.loot.SelectBagRarity;
import net.silentchaos512.treasurebags.loot.SetBagTypeFunction;
import net.silentchaos512.treasurebags.setup.TbItems;

public class ModLootTables
extends LootTableProvider {
    public ModLootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(Entities::new, (Object)LootContextParamSets.f_81415_), (Object)Pair.of(Gifts::new, (Object)LootContextParamSets.f_81416_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    private static LootPoolSingletonContainer.Builder<?> treasureBag(ResourceLocation bagType) {
        return LootItem.m_79579_(TbItems.TREASURE_BAG).m_79078_((LootItemFunction.Builder)SetBagTypeFunction.builder(bagType, new LootItemCondition[0]));
    }

    private static LootPoolSingletonContainer.Builder<?> bagOfRarity(Rarity rarity) {
        return LootItem.m_79579_(TbItems.TREASURE_BAG).m_79078_((LootItemFunction.Builder)SelectBagRarity.builder(rarity, new LootItemCondition[0]));
    }

    @Nonnull
    private static SetNameFunction setName(Component text) {
        Constructor constructor = ObfuscationReflectionHelper.findConstructor(SetNameFunction.class, (Class[])new Class[]{LootItemCondition[].class, Component.class, LootContext.EntityTarget.class});
        constructor.setAccessible(true);
        try {
            return (SetNameFunction)constructor.newInstance(new LootItemCondition[0], text, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    private static LootItemConditionalFunction.Builder<?> setCount(int count) {
        return SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count));
    }

    private static LootItemConditionalFunction.Builder<?> setCount(int min, int max) {
        return SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max));
    }

    public String m_6055_() {
        return "Treasure Bags - Loot Tables";
    }

    private static class Entities
    extends EntityLoot {
        private Entities() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(StandardEntityGroups.BOSS.getLootTable(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.COMMON).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.UNCOMMON).m_79707_(6)).m_79076_((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.RARE).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.EPIC).m_79707_(7))));
            consumer.accept(StandardEntityGroups.HOSTILE.getLootTable(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(200)).m_79076_((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.COMMON).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.UNCOMMON).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.RARE).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.EPIC).m_79707_(1))));
            consumer.accept(StandardEntityGroups.PEACEFUL.getLootTable(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)EmptyLootItem.m_79533_().m_79707_(500)).m_79076_((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.COMMON).m_79707_(12)).m_79076_((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.UNCOMMON).m_79707_(6)).m_79076_((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.RARE).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)ModLootTables.bagOfRarity(Rarity.EPIC).m_79707_(1))));
            consumer.accept(StandardEntityGroups.PLAYER.getLootTable(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_(LootItemKilledByPlayerCondition.m_81901_()).m_79076_(ModLootTables.treasureBag(Const.Bags.PLAYER))));
        }
    }

    private static class Gifts
    extends GiftLoot {
        private Gifts() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(Const.LootTables.STARTING_INVENTORY, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_(ModLootTables.treasureBag(Const.Bags.SPAWN))));
            consumer.accept(Const.LootTables.BAGS_SPAWN, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41837_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)8.0f))))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42410_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)10.0f))))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42000_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)20.0f))))));
            consumer.accept(Const.LootTables.BAGS_DUNGEON, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78742_))));
            consumer.accept(Const.LootTables.BAGS_ENDER, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42584_).m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42545_).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42108_).m_79707_(1))));
            consumer.accept(Const.LootTables.BAGS_FOOD, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42530_).m_79707_(10).m_79078_(ModLootTables.setCount(2, 4))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42531_).m_79707_(10).m_79078_(ModLootTables.setCount(2, 4))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42486_).m_79707_(7).m_79078_(ModLootTables.setCount(1, 3))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42580_).m_79707_(7).m_79078_(ModLootTables.setCount(1, 3))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42582_).m_79707_(8).m_79078_(ModLootTables.setCount(2, 4))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42406_).m_79707_(12).m_79078_(ModLootTables.setCount(2, 6)))));
            consumer.accept(Const.LootTables.BAGS_INGOTS, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_).m_79707_(100).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_151052_).m_79707_(70).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79707_(40).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42418_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.INGOTS).m_79707_(20))));
            consumer.accept(Const.LootTables.BAGS_LITERACY, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_79707_(12).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42516_).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)10.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41997_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42614_).m_79707_(1))).m_79161_(LootPool.m_79043_().m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.5f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_79078_(() -> ModLootTables.setName((Component)Component.m_237113_((String)"That Time I Was Slapped With a Salmon, Vol. 4")))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_79078_(() -> ModLootTables.setName((Component)Component.m_237113_((String)"The Adventures of Tardigrade Man")))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_79078_(() -> ModLootTables.setName((Component)Component.m_237113_((String)"Reading For Dummies")))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42517_).m_79078_(() -> ModLootTables.setName((Component)Component.m_237113_((String)"The Story of Larry the Sheep"))))));
            consumer.accept(Const.LootTables.BAGS_NATURE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41909_).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41864_).m_79707_(12).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)12.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41865_).m_79707_(8).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)5.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42029_).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42094_).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41982_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42046_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42028_).m_79707_(3).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42619_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42620_).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42533_).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.SEEDS).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.CROPS).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)ItemTags.f_13180_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)ItemTags.f_13149_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))));
            consumer.accept(Const.LootTables.BAGS_PLAYER, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42436_))));
            consumer.accept(Const.LootTables.BAGS_STICKS_AND_STONES, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79707_(15).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f)))).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_((TagKey)Tags.Items.RODS).m_79707_(1))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42594_).m_79707_(72).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)6.0f, (float)12.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41905_).m_79707_(48).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)7.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42170_).m_79707_(30).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42064_).m_79707_(30).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41958_).m_79707_(30).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)8.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42616_).m_79707_(1))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42500_).m_79707_(10).m_79078_(ModLootTables.setCount(2, 4))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42499_).m_79707_(4).m_79078_(ModLootTables.setCount(3, 8))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42262_).m_79707_(1).m_79078_(ModLootTables.setCount(1, 2)))));
            consumer.accept(Const.LootTables.BAGS_DEFAULT, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_(ModLootTables.setCount(4)))));
            consumer.accept(Const.LootTables.BAGS_TEST, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42416_).m_79078_(ModLootTables.setCount(5))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42417_).m_79078_(ModLootTables.setCount(2))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_))));
        }
    }
}

