/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.crafting.recipe;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.item.TreasureBagItem;
import net.silentchaos512.treasurebags.lib.IBagType;
import net.silentchaos512.treasurebags.setup.TbRecipes;

public final class ShapelessTreasureBagRecipe
extends ExtendedShapelessRecipe {
    private ResourceLocation typeName;

    public ShapelessTreasureBagRecipe(ShapelessRecipe recipe) {
        super(recipe);
    }

    public static void deserialize(JsonObject json, ShapelessTreasureBagRecipe recipe) {
        recipe.typeName = IBagType.nameFromJson(json.get("result").getAsJsonObject());
    }

    public static void decode(FriendlyByteBuf buffer, ShapelessTreasureBagRecipe recipe) {
        recipe.typeName = buffer.m_130281_();
    }

    public static void encode(FriendlyByteBuf buffer, ShapelessTreasureBagRecipe recipe) {
        buffer.m_130085_(recipe.typeName);
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        return this.getBaseRecipe().m_5818_(inv, worldIn);
    }

    public ItemStack m_8043_() {
        ItemStack copy = this.getBaseRecipe().m_8043_().m_41777_();
        return TreasureBagItem.setBagType(copy, this.typeName);
    }

    public ItemStack m_5874_(CraftingContainer inv) {
        ItemStack result = this.m_8043_();
        if (!(result.m_41720_() instanceof TreasureBagItem)) {
            TreasureBags.LOGGER.warn("Result of a treasure bag recipe is not a treasure bag? Recipe '{}' crafts {}", (Object)this.m_6423_(), (Object)result);
        }
        return result;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TbRecipes.SHAPELESS_BAG.get();
    }
}

