/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.crafting.ingredient;

import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.silentchaos512.treasurebags.TreasureBags;
import net.silentchaos512.treasurebags.item.TreasureBagItem;
import net.silentchaos512.treasurebags.lib.BagTypeManager;
import net.silentchaos512.treasurebags.lib.IBagType;
import net.silentchaos512.treasurebags.setup.TbItems;

public final class TreasureBagIngredient
extends Ingredient {
    private final ResourceLocation typeName;

    private TreasureBagIngredient(ResourceLocation typeName) {
        super(Stream.of(new Ingredient.ItemValue(((TreasureBagItem)((Object)TbItems.TREASURE_BAG.get())).stackOfType(typeName))));
        this.typeName = typeName;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        IBagType bagType = BagTypeManager.typeFromBag(stack);
        return bagType != null && bagType.getId().equals((Object)this.typeName);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<TreasureBagIngredient> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation NAME = TreasureBags.getId("bag");

        public TreasureBagIngredient parse(FriendlyByteBuf buffer) {
            return new TreasureBagIngredient(buffer.m_130281_());
        }

        public TreasureBagIngredient parse(JsonObject json) {
            return new TreasureBagIngredient(IBagType.nameFromJson(json));
        }

        public void write(FriendlyByteBuf buffer, TreasureBagIngredient ingredient) {
            buffer.m_130085_(ingredient.typeName);
        }
    }
}

