/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.config;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="treasurebags", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Config {
    private static boolean isStringList(Object obj) {
        if (obj instanceof List) {
            for (Object entry : (List)obj) {
                if (entry instanceof String) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Config() {
    }

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Common.spec);
    }

    public static final class Common {
        static final ForgeConfigSpec spec;
        public static final ForgeConfigSpec.BooleanValue alwaysSpawnItems;
        public static final ForgeConfigSpec.ConfigValue<List<? extends String>> disabledBagGroups;

        private Common() {
        }

        static {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            builder.push("item");
            builder.push("treasurebag");
            alwaysSpawnItems = builder.comment(new String[]{"If true, treasure bags will always spawn items on top of the player.", "Otherwise this only happens if the player's inventory is full", "Useful for bag-type items; Dank Storage, SGems Gem Bag, backpacks"}).define("alwaysSpawnItems", false);
            disabledBagGroups = builder.comment("Disables all treasure bags in these groups. The built-in bags are in the \"default\" and \"example\" groups").define("disabledGroups", (Object)ImmutableList.of((Object)"example", (Object)"another_example"), Config::isStringList);
            builder.pop();
            builder.pop();
            spec = builder.build();
        }
    }
}

