/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.treasurebags.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.lib.util.PlayerUtils;
import net.silentchaos512.treasurebags.item.TreasureBagItem;
import net.silentchaos512.treasurebags.lib.BagTypeManager;
import net.silentchaos512.treasurebags.lib.IBagType;
import net.silentchaos512.treasurebags.setup.TbItems;

public final class TreasureBagsCommand {
    private static final SuggestionProvider<CommandSourceStack> bagTypeSuggestions = (ctx, builder) -> SharedSuggestionProvider.m_82957_(BagTypeManager.getValues().stream().map(IBagType::getId), (SuggestionsBuilder)builder);

    private TreasureBagsCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"treasurebags").requires(source -> source.m_6761_(2));
        builder.then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"bagType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(bagTypeSuggestions).executes(context -> TreasureBagsCommand.giveBags((CommandContext<CommandSourceStack>)context, 1))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            return TreasureBagsCommand.giveBags((CommandContext<CommandSourceStack>)context, count);
        })))));
        builder.then(Commands.m_82127_((String)"list").executes(TreasureBagsCommand::listBagTypes));
        dispatcher.register(builder);
    }

    private static int giveBags(CommandContext<CommandSourceStack> context, int bagCount) throws CommandSyntaxException {
        ResourceLocation bagTypeId = ResourceLocationArgument.m_107011_(context, (String)"bagType");
        IBagType bagType = BagTypeManager.getValue(bagTypeId);
        if (bagType == null) {
            ((CommandSourceStack)context.getSource()).m_81352_(TreasureBagsCommand.translate("give.invalid", bagTypeId.toString()));
            return 0;
        }
        for (ServerPlayer player : EntityArgument.m_91477_(context, (String)"players")) {
            ItemStack stack = ((TreasureBagItem)((Object)TbItems.TREASURE_BAG.get())).stackOfType(bagType, bagCount);
            PlayerUtils.giveItem((Player)player, (ItemStack)stack);
            ((CommandSourceStack)context.getSource()).m_81354_(TreasureBagsCommand.translate("give.success", bagCount, bagType.getCustomName(), player.m_6302_()), true);
        }
        return 1;
    }

    private static int listBagTypes(CommandContext<CommandSourceStack> context) {
        String str = BagTypeManager.getValues().stream().map(type -> type.getId().toString()).collect(Collectors.joining(", "));
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)str), true);
        return 1;
    }

    private static Component translate(String key, Object ... args) {
        return Component.m_237110_((String)("command.treasurebags." + key), (Object[])args);
    }
}

