/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easy_villagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easy_villagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.MultiItemStackHandler;
import de.maxhenkel.easyvillagers.blocks.IncubatorBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.VillagerIncubateSlot;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class IncubatorTileentity
extends VillagerTileentity
implements IServerTickableBlockEntity {
    protected NonNullList<ItemStack> inputInventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected NonNullList<ItemStack> outputInventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected LazyOptional<MultiItemStackHandler> itemHandler = LazyOptional.of(() -> new MultiItemStackHandler(this.inputInventory, this.outputInventory, VillagerIncubateSlot::isValid));

    public IncubatorTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.INCUBATOR.get(), ((IncubatorBlock)ModBlocks.INCUBATOR.get()).m_49966_(), pos, state);
    }

    @Override
    public void tickServer() {
        if (!this.hasVillager()) {
            for (ItemStack stack : this.inputInventory) {
                if (!(stack.m_41720_() instanceof VillagerItem)) continue;
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(1);
                this.setVillager(copy);
                stack.m_41774_(1);
                this.sync();
                break;
            }
        }
        if (this.hasVillager()) {
            VillagerBlockBase.playRandomVillagerSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12503_);
            EasyVillagerEntity villagerEntity = this.getVillagerEntity();
            if (villagerEntity.m_6162_()) {
                if (this.advanceAge(Math.min((Integer)Main.SERVER_CONFIG.incubatorSpeed.get(), Math.abs(villagerEntity.m_146764_())))) {
                    this.sync();
                }
            } else {
                this.advanceAge(1);
            }
            if (villagerEntity.m_146764_() > 20) {
                for (int i = 0; i < this.outputInventory.size(); ++i) {
                    ItemStack stack = (ItemStack)this.outputInventory.get(i);
                    if (!stack.m_41619_()) continue;
                    this.outputInventory.set(i, (Object)this.removeVillager().m_41777_());
                    this.sync();
                    break;
                }
            }
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("InputInventory", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.inputInventory, (boolean)true));
        compound.m_128365_("OutputInventory", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.outputInventory, (boolean)true));
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("InputInventory"), this.inputInventory);
        ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("OutputInventory"), this.outputInventory);
        super.m_142466_(compound);
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory, () -> ((IncubatorTileentity)this).m_6596_());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((IncubatorTileentity)this).m_6596_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        this.itemHandler.invalidate();
        super.m_7651_();
    }
}

