/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easy_villagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easy_villagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.MultiItemStackHandler;
import de.maxhenkel.easyvillagers.blocks.ConverterBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.VillagerConvertSlot;
import de.maxhenkel.easyvillagers.items.VillagerItem;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class ConverterTileentity
extends VillagerTileentity
implements IServerTickableBlockEntity {
    protected NonNullList<ItemStack> inputInventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected NonNullList<ItemStack> outputInventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected long timer;
    protected UUID owner;
    protected LazyOptional<MultiItemStackHandler> itemHandler = LazyOptional.of(() -> new MultiItemStackHandler(this.inputInventory, this.outputInventory, VillagerConvertSlot::isValid));

    public ConverterTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.CONVERTER.get(), ((ConverterBlock)ModBlocks.CONVERTER.get()).m_49966_(), pos, state);
    }

    @Override
    public void tickServer() {
        if (this.timer <= 0L && !this.hasVillager()) {
            for (ItemStack stack : this.inputInventory) {
                if (!(stack.m_41720_() instanceof VillagerItem) || !this.consumeConvertItems()) continue;
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(1);
                this.setVillager(copy);
                stack.m_41774_(1);
                this.sync();
                break;
            }
        }
        if (this.hasVillager()) {
            Player ownerPlayer;
            if (this.advanceAge()) {
                this.sync();
            }
            if (this.timer == (long)ConverterTileentity.getZombifyTime()) {
                VillagerBlockBase.playVillagerSound(this.f_58857_, this.f_58858_, SoundEvents.f_12609_);
                this.sync();
            } else if (this.timer == (long)ConverterTileentity.getCureTime()) {
                VillagerBlockBase.playVillagerSound(this.f_58857_, this.f_58858_, SoundEvents.f_12644_);
                this.sync();
            } else if (this.timer == (long)ConverterTileentity.getConvertTime()) {
                VillagerBlockBase.playVillagerSound(this.f_58857_, this.f_58858_, SoundEvents.f_12616_);
                this.sync();
            } else if (this.timer >= (long)ConverterTileentity.getFinalizeTime() && (ownerPlayer = this.getOwnerPlayer()) != null) {
                for (int i = 0; i < this.outputInventory.size(); ++i) {
                    ItemStack stack = (ItemStack)this.outputInventory.get(i);
                    if (!stack.m_41619_()) continue;
                    EasyVillagerEntity villagerEntity = this.getVillagerEntity();
                    villagerEntity.m_6814_(ReputationEventType.f_26985_, (Entity)ownerPlayer);
                    this.outputInventory.set(i, (Object)this.removeVillager().m_41777_());
                    this.timer = 0L;
                    this.sync();
                    break;
                }
            }
            ++this.timer;
            this.m_6596_();
            if (this.timer < (long)ConverterTileentity.getZombifyTime() || this.timer >= (long)ConverterTileentity.getConvertTime()) {
                VillagerBlockBase.playRandomVillagerSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12503_);
            } else {
                VillagerBlockBase.playRandomVillagerSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12615_);
            }
            VillagerBlockBase.playRandomVillagerSound(this.f_58857_, this.m_58899_(), SoundEvents.f_12598_);
        } else if (this.timer != 0L) {
            this.timer = 0L;
            this.m_6596_();
        }
    }

    private boolean consumeConvertItems() {
        ItemStack appleStack = null;
        ItemStack potionStack = null;
        for (ItemStack stack : this.inputInventory) {
            if (appleStack == null && stack.m_41720_() == Items.f_42436_) {
                appleStack = stack;
            }
            if (potionStack != null || !ConverterTileentity.isWeakness(stack)) continue;
            potionStack = stack;
        }
        if (appleStack != null && potionStack != null) {
            appleStack.m_41774_(1);
            potionStack.m_41774_(1);
            return true;
        }
        return false;
    }

    public static boolean isWeakness(ItemStack stack) {
        return PotionUtils.m_43579_((ItemStack)stack).equals(Potions.f_43593_) || PotionUtils.m_43579_((ItemStack)stack).equals(Potions.f_43594_);
    }

    public long getTimer() {
        return this.timer;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Player getOwnerPlayer() {
        if (this.owner == null) {
            return null;
        }
        if (this.f_58857_ instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)this.f_58857_;
            return serverWorld.m_7654_().m_6846_().m_11259_(this.owner);
        }
        return this.f_58857_.m_46003_(this.owner);
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("InputInventory", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.inputInventory, (boolean)true));
        compound.m_128365_("OutputInventory", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.outputInventory, (boolean)true));
        compound.m_128356_("Timer", this.timer);
        if (this.owner != null) {
            compound.m_128362_("Owner", this.owner);
        }
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("InputInventory"), this.inputInventory);
        ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("OutputInventory"), this.outputInventory);
        this.timer = compound.m_128454_("Timer");
        this.owner = compound.m_128441_("Owner") ? compound.m_128342_("Owner") : null;
        super.m_142466_(compound);
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory, () -> ((ConverterTileentity)this).m_6596_());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((ConverterTileentity)this).m_6596_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public static int getZombifyTime() {
        return 60;
    }

    public static int getCureTime() {
        return ConverterTileentity.getZombifyTime() + 60;
    }

    public static int getConvertTime() {
        return ConverterTileentity.getCureTime() + (Integer)Main.SERVER_CONFIG.convertingTime.get();
    }

    public static int getFinalizeTime() {
        return ConverterTileentity.getConvertTime() + 60;
    }

    public void m_7651_() {
        this.itemHandler.invalidate();
        super.m_7651_();
    }
}

