/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easy_villagers.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.easy_villagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easy_villagers.corelib.item.ItemUtils;
import de.maxhenkel.easyvillagers.Main;
import de.maxhenkel.easyvillagers.MultiItemStackHandler;
import de.maxhenkel.easyvillagers.blocks.AutoTraderBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.TraderTileentityBase;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class AutoTraderTileentity
extends TraderTileentityBase
implements ITickableBlockEntity {
    protected Container tradeGuiInv = new SimpleContainer(3);
    protected final NonNullList<ItemStack> inputInventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected final NonNullList<ItemStack> outputInventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    protected int tradeIndex;
    protected LazyOptional<MultiItemStackHandler> itemHandler = LazyOptional.of(() -> new MultiItemStackHandler(this.inputInventory, this.outputInventory));
    protected ItemStackHandler outputHandler = new ItemStackHandler(this.outputInventory);

    public AutoTraderTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.AUTO_TRADER.get(), ((AutoTraderBlock)ModBlocks.AUTO_TRADER.get()).m_49966_(), pos, state);
    }

    @Override
    public void tick() {
        if (!this.hasVillager()) {
            return;
        }
        if (this.f_58857_.m_46467_() % (long)((Integer)Main.SERVER_CONFIG.autoTraderCooldown.get()).intValue() != 0L) {
            return;
        }
        MerchantOffer offer = this.getOffer();
        if (offer == null || offer.m_45380_() || this.inputInventory.isEmpty()) {
            return;
        }
        EasyVillagerEntity villager = this.getVillagerEntity();
        if (!(this.hasEnoughItems(offer.m_45358_(), false) && this.hasEnoughItems(offer.m_45364_(), false) && this.canFitItems(offer.m_45368_(), false))) {
            return;
        }
        this.hasEnoughItems(offer.m_45358_(), true);
        this.hasEnoughItems(offer.m_45364_(), true);
        this.canFitItems(offer.m_45368_(), true);
        offer.m_45374_();
        villager.m_35546_(villager.m_7809_() + offer.m_45379_());
        if (villager.m_35527_()) {
            villager.f_35374_ = true;
        }
        this.m_6596_();
    }

    protected boolean hasEnoughItems(ItemStack buying, boolean remove) {
        if (buying.m_41619_()) {
            return true;
        }
        int amount = buying.m_41613_();
        for (ItemStack stack : this.inputInventory) {
            if (!ItemUtils.isStackable(stack, buying)) continue;
            int am = Math.min(amount, stack.m_41613_());
            if (remove) {
                stack.m_41774_(am);
            }
            if ((amount -= am) > 0) continue;
            return true;
        }
        return false;
    }

    protected boolean canFitItems(ItemStack insert, boolean doInsert) {
        if (insert.m_41619_()) {
            return true;
        }
        ItemStack stack = insert.m_41777_();
        for (int i = 0; i < this.outputHandler.getSlots() && !(stack = this.outputHandler.insertItem(i, stack, !doInsert)).m_41619_(); ++i) {
        }
        return stack.m_41619_();
    }

    public Container getTradeGuiInv() {
        this.updateTradeInv();
        return this.tradeGuiInv;
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
        this.updateTradeInv();
        this.m_6596_();
    }

    @Override
    protected void onAddVillager(EasyVillagerEntity villager) {
        super.onAddVillager(villager);
        this.updateTradeInv();
    }

    @Override
    public void setWorkstation(Block workstation) {
        super.setWorkstation(workstation);
        this.updateTradeInv();
    }

    public void nextTrade() {
        int tradeCount = this.getTradeCount();
        if (tradeCount > 0) {
            this.setTradeIndex(Math.floorMod(this.tradeIndex + 1, tradeCount));
        }
    }

    public void prevTrade() {
        int tradeCount = this.getTradeCount();
        if (tradeCount > 0) {
            this.setTradeIndex(Math.floorMod(this.tradeIndex - 1, tradeCount));
        }
    }

    protected void updateTradeInv() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            this.tradeGuiInv.m_6211_();
            return;
        }
        villagerEntity.recalculateOffers();
        MerchantOffer offer = this.getOffer();
        if (offer == null) {
            this.tradeGuiInv.m_6211_();
            return;
        }
        this.tradeGuiInv.m_6836_(0, offer.m_45358_());
        this.tradeGuiInv.m_6836_(1, offer.m_45364_());
        this.tradeGuiInv.m_6836_(2, offer.m_45368_());
    }

    @Nullable
    public MerchantOffer getOffer() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return null;
        }
        MerchantOffers offers = villagerEntity.m_6616_();
        if (this.tradeIndex < 0 || this.tradeIndex >= offers.size()) {
            return null;
        }
        return (MerchantOffer)offers.get(this.tradeIndex);
    }

    protected int getTradeCount() {
        EasyVillagerEntity villagerEntity = this.getVillagerEntity();
        if (villagerEntity == null) {
            return 0;
        }
        return villagerEntity.m_6616_().size();
    }

    @Override
    protected long calculateNextRestock() {
        return (Integer)Main.SERVER_CONFIG.autoTraderMinRestockTime.get() + this.f_58857_.f_46441_.m_188503_(Math.max((Integer)Main.SERVER_CONFIG.autoTraderMaxRestockTime.get() - (Integer)Main.SERVER_CONFIG.autoTraderMinRestockTime.get(), 1));
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("Trade", this.tradeIndex);
        compound.m_128365_("InputInventory", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.inputInventory, (boolean)true));
        compound.m_128365_("OutputInventory", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.outputInventory, (boolean)true));
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.tradeIndex = compound.m_128451_("Trade");
        ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("InputInventory"), this.inputInventory);
        ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("OutputInventory"), this.outputInventory);
    }

    public Container getInputInventory() {
        return new ItemListInventory(this.inputInventory, () -> ((AutoTraderTileentity)this).m_6596_());
    }

    public Container getOutputInventory() {
        return new ItemListInventory(this.outputInventory, () -> ((AutoTraderTileentity)this).m_6596_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        this.itemHandler.invalidate();
        super.m_7651_();
    }
}

