/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks;

import de.maxhenkel.easy_villagers.corelib.block.IItemBlock;
import de.maxhenkel.easy_villagers.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.easy_villagers.corelib.client.CustomRendererBlockItem;
import de.maxhenkel.easy_villagers.corelib.client.ItemRenderer;
import de.maxhenkel.easyvillagers.ItemTileEntityCache;
import de.maxhenkel.easyvillagers.ModItemGroups;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.TraderBlock;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.IncubatorTileentity;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.IncubatorContainer;
import de.maxhenkel.easyvillagers.items.render.IncubatorItemRenderer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IncubatorBlock
extends VillagerBlockBase
implements EntityBlock,
IItemBlock {
    public IncubatorBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(2.5f).m_60918_(SoundType.f_56743_).m_60955_());
    }

    @Override
    public Item toItem() {
        return new CustomRendererBlockItem(this, new Item.Properties().m_41491_(ModItemGroups.TAB_EASY_VILLAGERS)){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public ItemRenderer createItemRenderer() {
                return new IncubatorItemRenderer();
            }
        };
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter blockGetter, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_5871_(stack, blockGetter, components, tooltipFlag);
        IncubatorTileentity trader = ItemTileEntityCache.getTileEntity(stack, () -> new IncubatorTileentity(BlockPos.f_121853_, ((TraderBlock)ModBlocks.TRADER.get()).m_49966_()));
        EasyVillagerEntity villager = trader.getVillagerEntity();
        if (villager != null) {
            components.add(villager.getAdvancedName());
        }
    }

    public InteractionResult m_6227_(final BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (!(tileEntity instanceof IncubatorTileentity)) {
            return super.m_6227_(state, worldIn, pos, player, handIn, hit);
        }
        final IncubatorTileentity incubator = (IncubatorTileentity)tileEntity;
        player.m_5893_(new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)state.m_60734_().m_7705_());
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
                return new IncubatorContainer(id, playerInventory, incubator.getInputInventory(), incubator.getOutputInventory());
            }
        });
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level1, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new IncubatorTileentity(blockPos, blockState);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }
}

