/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mekanism.client.gui.GuiFilterHolder;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDigitalSwitch;
import mekanism.client.gui.element.button.FilterButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.filter.miner.GuiMinerFilerSelect;
import mekanism.client.gui.element.window.filter.miner.GuiMinerItemStackFilter;
import mekanism.client.gui.element.window.filter.miner.GuiMinerMaterialFilter;
import mekanism.client.gui.element.window.filter.miner.GuiMinerModIDFilter;
import mekanism.client.gui.element.window.filter.miner.GuiMinerTagFilter;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.miner.MinerItemStackFilter;
import mekanism.common.content.miner.MinerMaterialFilter;
import mekanism.common.content.miner.MinerModIDFilter;
import mekanism.common.content.miner.MinerTagFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.network.to_server.PacketGuiButtonPress;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.InputValidator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiDigitalMinerConfig
extends GuiFilterHolder<MinerFilter<?>, TileEntityDigitalMiner, MekanismTileContainer<TileEntityDigitalMiner>> {
    private static final ResourceLocation INVERSE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "switch/inverse.png");
    private final int maxHeightLength;
    private GuiTextField radiusField;
    private GuiTextField minField;
    private GuiTextField maxField;

    public GuiDigitalMinerConfig(MekanismTileContainer<TileEntityDigitalMiner> container, Inventory inv, Component title) {
        super(container, inv, title);
        Level level = inv.f_35978_.f_19853_;
        this.maxHeightLength = Math.max(Integer.toString(level.m_141937_()).length(), Integer.toString(level.m_151558_() - 1).length());
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new TranslationButton(this, 56, 136, 96, 20, MekanismLang.BUTTON_NEW_FILTER, () -> this.addWindow(new GuiMinerFilerSelect(this, (TileEntityDigitalMiner)this.tile))));
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 5, 5, 11, 14, this.getButtonLocation("back"), () -> Mekanism.packetHandler().sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON, this.tile)), this.getOnHover(MekanismLang.BACK)));
        this.addRenderableWidget(new GuiDigitalSwitch(this, 10, 115, INVERSE, ((TileEntityDigitalMiner)this.tile)::getInverse, (Component)MekanismLang.MINER_INVERSE.translate(new Object[0]), () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.INVERSE_BUTTON, this.tile)), GuiDigitalSwitch.SwitchType.LEFT_ICON));
        this.addRenderableWidget(new GuiSlot(SlotType.NORMAL, this, 13, 135)).setRenderAboveSlots().setRenderHover(true).stored(() -> new ItemStack((ItemLike)((TileEntityDigitalMiner)this.tile).getInverseReplaceTarget())).click((element, mouseX, mouseY) -> {
            if (Screen.m_96638_()) {
                this.updateInverseReplaceTarget(Items.f_41852_);
            } else {
                ItemStack stack = this.f_96541_.f_91074_.f_36096_.m_142621_();
                if (!stack.m_41619_() && stack.m_41720_() instanceof BlockItem) {
                    this.updateInverseReplaceTarget(stack.m_41720_());
                }
            }
        }).setGhostHandler(ingredient -> this.updateInverseReplaceTarget(((ItemStack)ingredient).m_41720_()));
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 35, 137, 14, 16, this.getButtonLocation("exclamation"), () -> Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.INVERSE_REQUIRES_REPLACEMENT_BUTTON, this.tile)), this.getOnHover(() -> MekanismLang.MINER_REQUIRE_REPLACE_INVERSE.translate(BooleanStateDisplay.YesNo.of(((TileEntityDigitalMiner)this.tile).getInverseRequiresReplacement())))));
        this.radiusField = this.addRenderableWidget(new GuiTextField(this, 13, 49, 38, 11));
        this.radiusField.setMaxLength(Integer.toString(MekanismConfig.general.minerMaxRadius.get()).length());
        this.radiusField.setInputValidator(InputValidator.DIGIT);
        this.radiusField.configureDigitalBorderInput(() -> this.setText(this.radiusField, PacketGuiInteract.GuiInteraction.SET_RADIUS));
        this.minField = this.addRenderableWidget(new GuiTextField(this, 13, 74, 38, 11));
        this.minField.setMaxLength(this.maxHeightLength);
        this.minField.setInputValidator(InputValidator.DIGIT_OR_NEGATIVE);
        this.minField.configureDigitalBorderInput(() -> this.setText(this.minField, PacketGuiInteract.GuiInteraction.SET_MIN_Y));
        this.maxField = this.addRenderableWidget(new GuiTextField(this, 13, 99, 38, 11));
        this.maxField.setMaxLength(this.maxHeightLength);
        this.maxField.setInputValidator(InputValidator.DIGIT_OR_NEGATIVE);
        this.maxField.configureDigitalBorderInput(() -> this.setText(this.maxField, PacketGuiInteract.GuiInteraction.SET_MAX_Y));
        this.trackWarning(WarningTracker.WarningType.FILTER_HAS_BLACKLISTED_ELEMENT, () -> ((TileEntityDigitalMiner)this.tile).getFilterManager().anyEnabledMatch(MinerFilter::hasBlacklistedElement));
    }

    private void updateInverseReplaceTarget(Item target) {
        Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionItem.DIGITAL_MINER_INVERSE_REPLACE_ITEM, (BlockEntity)this.tile, new ItemStack((ItemLike)target)));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    @Override
    protected void addGenericTabs() {
    }

    @Override
    protected void drawForegroundText(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        super.drawForegroundText(matrix, mouseX, mouseY);
        this.renderTitleText(matrix);
        this.drawScaledTextScaledBound(matrix, (Component)MekanismLang.FILTERS.translate(new Object[0]), 14.0f, 22.0f, this.screenTextColor(), 36.0f, 0.8f);
        this.drawScaledTextScaledBound(matrix, (Component)MekanismLang.FILTER_COUNT.translate(this.getFilterManager().count()), 14.0f, 31.0f, this.screenTextColor(), 36.0f, 0.8f);
        this.drawScaledTextScaledBound(matrix, (Component)MekanismLang.MINER_RADIUS.translate(((TileEntityDigitalMiner)this.tile).getRadius()), 14.0f, 40.0f, this.screenTextColor(), 36.0f, 0.8f);
        this.drawScaledTextScaledBound(matrix, (Component)MekanismLang.MIN.translate(((TileEntityDigitalMiner)this.tile).getMinY()), 14.0f, 65.0f, this.screenTextColor(), 36.0f, 0.8f);
        this.drawScaledTextScaledBound(matrix, (Component)MekanismLang.MAX.translate(((TileEntityDigitalMiner)this.tile).getMaxY()), 14.0f, 90.0f, this.screenTextColor(), 36.0f, 0.8f);
    }

    @Override
    public void drawTitleText(PoseStack matrix, Component text, float y) {
        int leftShift = 11;
        int xSize = this.getXSize() - leftShift;
        int maxLength = xSize - 12;
        float textWidth = this.getStringWidth(text);
        float scale = Math.min(1.0f, (float)maxLength / textWidth);
        this.drawScaledCenteredText(matrix, text, (float)leftShift + (float)xSize / 2.0f, y, this.titleTextColor(), scale);
    }

    @Override
    protected void onClick(IFilter<?> filter, int index) {
        if (filter instanceof IItemStackFilter) {
            this.addWindow(GuiMinerItemStackFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerItemStackFilter)filter));
        } else if (filter instanceof ITagFilter) {
            this.addWindow(GuiMinerTagFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerTagFilter)filter));
        } else if (filter instanceof IMaterialFilter) {
            this.addWindow(GuiMinerMaterialFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerMaterialFilter)filter));
        } else if (filter instanceof IModIDFilter) {
            this.addWindow(GuiMinerModIDFilter.edit(this, (TileEntityDigitalMiner)this.tile, (MinerModIDFilter)filter));
        }
    }

    @Override
    protected FilterButton addFilterButton(FilterButton button) {
        return super.addFilterButton(button).warning(WarningTracker.WarningType.FILTER_HAS_BLACKLISTED_ELEMENT, filter -> {
            if (!(filter instanceof MinerFilter)) return false;
            MinerFilter minerFilter = (MinerFilter)filter;
            if (!filter.isEnabled()) return false;
            if (!minerFilter.hasBlacklistedElement()) return false;
            return true;
        });
    }

    private void setText(GuiTextField field, PacketGuiInteract.GuiInteraction interaction) {
        if (!field.getText().isEmpty()) {
            try {
                Mekanism.packetHandler().sendToServer(new PacketGuiInteract(interaction, (BlockEntity)this.tile, Integer.parseInt(field.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            field.setText("");
        }
    }

    @Override
    protected List<ItemStack> getTagStacks(String tagName) {
        return TagCache.getBlockTagStacks(tagName).stacks();
    }

    @Override
    protected List<ItemStack> getModIDStacks(String tagName) {
        return TagCache.getBlockModIDStacks(tagName).stacks();
    }
}

