/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiSideHolder;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GuiResizeControls
extends GuiSideHolder {
    private final MekanismImageButton expandButton;
    private final MekanismImageButton shrinkButton;
    private final Consumer<ResizeType> resizeHandler;
    private int tooltipTicks;
    private static final ResourceLocation MINUS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "minus.png");
    private static final ResourceLocation PLUS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "plus.png");

    public GuiResizeControls(IGuiWrapper gui, int y, Consumer<ResizeType> resizeHandler) {
        super(gui, -26, y, 39, true, false);
        this.resizeHandler = resizeHandler;
        this.expandButton = this.addChild(new MekanismImageButton(gui, this.relativeX + 4, this.relativeY + 5, 19, 9, 19, 9, PLUS, () -> this.handleResize(ResizeType.EXPAND_Y)));
        this.shrinkButton = this.addChild(new MekanismImageButton(gui, this.relativeX + 4, this.relativeY + 25, 19, 9, 19, 9, MINUS, () -> this.handleResize(ResizeType.SHRINK_Y)));
        this.updateButtonState();
        this.f_93623_ = true;
    }

    @Override
    public void tick() {
        super.tick();
        this.tooltipTicks = Math.max(0, this.tooltipTicks - 1);
    }

    @Override
    public void m_7428_(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        if (this.tooltipTicks > 0 && !this.expandButton.f_93623_) {
            this.displayTooltips(matrix, mouseX, mouseY, new Component[]{MekanismLang.QIO_COMPENSATE_TOOLTIP.translate(new Object[0])});
        }
    }

    @Override
    public void renderForeground(PoseStack matrix, int mouseX, int mouseY) {
        super.renderForeground(matrix, mouseX, mouseY);
        this.drawScaledCenteredTextScaledBound(matrix, (Component)MekanismLang.HEIGHT.translate(new Object[0]), (float)this.relativeX + 13.5f, (float)this.relativeY + 15.5f, this.titleTextColor(), this.f_93618_ - 4, 0.7f);
    }

    public void m_5716_(double mouseX, double mouseY) {
        super.m_5716_(mouseX, mouseY);
        if (!this.expandButton.f_93623_ && mouseX >= (double)this.expandButton.f_93620_ && mouseX < (double)(this.expandButton.f_93620_ + this.expandButton.m_5711_()) && mouseY >= (double)this.expandButton.f_93621_ && mouseY < (double)(this.expandButton.f_93621_ + this.expandButton.m_93694_())) {
            this.tooltipTicks = 100;
        }
    }

    @Override
    protected void colorTab() {
        MekanismRenderer.color(SpecialColors.TAB_RESIZE_CONTROLS);
    }

    private void handleResize(ResizeType type) {
        this.resizeHandler.accept(type);
        this.updateButtonState();
    }

    private void updateButtonState() {
        int index = this.getIndex();
        this.expandButton.f_93623_ = index < QIOItemViewerContainer.getSlotsYMax();
        this.shrinkButton.f_93623_ = index > 2;
    }

    private int getIndex() {
        return MekanismConfig.client.qioItemViewerSlotsY.get();
    }

    public static enum ResizeType {
        EXPAND_X,
        EXPAND_Y,
        SHRINK_X,
        SHRINK_Y;

    }
}

