/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiRedstoneControlTab;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.window.GuiUpgradeWindowTab;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiMekanismTile<TILE extends TileEntityMekanism, CONTAINER extends MekanismTileContainer<TILE>>
extends GuiMekanism<CONTAINER> {
    protected final TILE tile;
    @Nullable
    private GuiUpgradeWindowTab upgradeWindowTab;

    protected GuiMekanismTile(CONTAINER container, Inventory inv, Component title) {
        super(container, inv, title);
        this.tile = ((MekanismTileContainer)container).getTileEntity();
    }

    public TILE getTileEntity() {
        return this.tile;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addGenericTabs();
    }

    protected void addGenericTabs() {
        if (((TileEntityMekanism)this.tile).supportsUpgrades()) {
            this.upgradeWindowTab = this.addRenderableWidget(new GuiUpgradeWindowTab(this, (TileEntityMekanism)this.tile, () -> this.upgradeWindowTab));
        }
        if (((TileEntityMekanism)this.tile).supportsRedstone()) {
            this.addRenderableWidget(new GuiRedstoneControlTab(this, (TileEntityMekanism)this.tile));
        }
        if (this.tile.getCapability(Capabilities.SECURITY_OBJECT).isPresent()) {
            this.addSecurityTab();
        }
    }

    protected void addSecurityTab() {
        this.addRenderableWidget(new GuiSecurityTab((IGuiWrapper)this, (ICapabilityProvider)this.tile));
    }

    @Override
    protected void drawForegroundText(@NotNull PoseStack matrix, int mouseX, int mouseY) {
        ItemStack stack;
        super.drawForegroundText(matrix, mouseX, mouseY);
        if (this.tile instanceof ISideConfiguration && !(stack = this.getMinecraft().f_91074_.f_36096_.m_142621_()).m_41619_() && stack.m_41720_() instanceof ItemConfigurator) {
            for (int i = 0; i < ((MekanismTileContainer)this.f_97732_).f_38839_.size(); ++i) {
                Slot slot = (Slot)((MekanismTileContainer)this.f_97732_).f_38839_.get(i);
                if (!this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
                DataType data = this.getFromSlot(slot);
                if (data == null) break;
                EnumColor color = data.getColor();
                this.displayTooltips(matrix, mouseX - this.f_97735_, mouseY - this.f_97736_, new Component[]{MekanismLang.GENERIC_WITH_PARENTHESIS.translateColored(color, data, color.getName())});
                break;
            }
        }
    }

    private DataType getFromSlot(Slot slot) {
        if (slot.f_40219_ < this.tile.getSlots() && slot instanceof InventoryContainerSlot) {
            InventoryContainerSlot containerSlot = (InventoryContainerSlot)slot;
            ISideConfiguration config = (ISideConfiguration)this.tile;
            ConfigInfo info = config.getConfig().getConfig(TransmissionType.ITEM);
            if (info != null) {
                Set<DataType> supportedDataTypes = info.getSupportedDataTypes();
                IInventorySlot inventorySlot = containerSlot.getInventorySlot();
                for (DataType type : supportedDataTypes) {
                    InventorySlotInfo inventorySlotInfo;
                    ISlotInfo slotInfo = info.getSlotInfo(type);
                    if (!(slotInfo instanceof InventorySlotInfo) || !(inventorySlotInfo = (InventorySlotInfo)slotInfo).hasSlot(inventorySlot)) continue;
                    return type;
                }
            }
        }
        return null;
    }
}

