/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.itemsearch;

import at.ridgo8.moreoverlays.MoreOverlays;
import at.ridgo8.moreoverlays.itemsearch.ItemUtils;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.library.gui.IngredientListOverlayDummy;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@JeiPlugin
public class JeiModule
implements IModPlugin {
    public static IIngredientListOverlay overlay;
    public static IIngredientFilter filter;
    private static IJeiHelpers jeiHelpers;
    private static IngredientListOverlay overlayInternal;
    private static EditBox textField;
    public static IJeiRuntime jeiRuntime;
    public static boolean tryAgain;

    public static void updateModule() {
        boolean isInstanceOfIngredientListOverlay = false;
        try {
            isInstanceOfIngredientListOverlay = overlay instanceof IngredientListOverlay;
            if (tryAgain && isInstanceOfIngredientListOverlay) {
                MoreOverlays.logger.info("JEI integration: IngredientListOverlay loaded");
            }
            if (overlay instanceof IngredientListOverlayDummy) {
                tryAgain = true;
                MoreOverlays.logger.warn("JEI integration failed. Trying again later");
            }
            if (isInstanceOfIngredientListOverlay) {
                tryAgain = false;
            }
        }
        catch (NoClassDefFoundError e) {
            MoreOverlays.logger.error("Something went wrong. JEI integration failed");
            tryAgain = false;
        }
        if (isInstanceOfIngredientListOverlay) {
            overlayInternal = (IngredientListOverlay)overlay;
            try {
                Field searchField = IngredientListOverlay.class.getDeclaredField("searchField");
                searchField.setAccessible(true);
                textField = (EditBox)searchField.get(overlayInternal);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                try {
                    Field searchField = IngredientListOverlay.class.getDeclaredField("textFieldFilter");
                    searchField.setAccessible(true);
                    textField = (EditBox)searchField.get(overlayInternal);
                }
                catch (IllegalAccessException | NoSuchFieldException f) {
                    MoreOverlays.logger.error("Something went wrong. Tried to load JEI Search Text Field object");
                    e.printStackTrace();
                    f.printStackTrace();
                }
            }
        } else {
            overlayInternal = null;
            textField = null;
        }
    }

    public static EditBox getJEITextField() {
        return textField;
    }

    public static boolean areItemsEqualInterpreter(ItemStack stack1, ItemStack stack2) {
        if (jeiHelpers == null) {
            return ItemUtils.matchNBT(stack1, stack2);
        }
        return jeiHelpers.getStackHelper().isEquivalent(stack1, stack2, UidContext.Ingredient);
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        JeiModule.jeiRuntime = jeiRuntime;
        overlay = jeiRuntime.getIngredientListOverlay();
        filter = jeiRuntime.getIngredientFilter();
        JeiModule.updateModule();
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        jeiHelpers = registration.getJeiHelpers();
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("moreoverlays", "jei_module");
    }

    static {
        tryAgain = false;
    }
}

