/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbuilder.modules.builder.BuilderConfiguration;
import mcjty.rftoolsbuilder.modules.builder.BuilderModule;
import mcjty.rftoolsbuilder.modules.builder.SpaceChamberRepository;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SpaceChamberControllerTileEntity
extends GenericTileEntity {
    private BlockPos minCorner;
    private BlockPos maxCorner;
    private int channel = -1;

    public SpaceChamberControllerTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BuilderModule.TYPE_SPACE_CHAMBER_CONTROLLER.get(), pos, state);
    }

    public BlockPos getMinCorner() {
        return this.minCorner;
    }

    public BlockPos getMaxCorner() {
        return this.maxCorner;
    }

    public void createChamber(Player player) {
        int i;
        BlockPos pos = this.m_58899_();
        int x1 = pos.m_123341_();
        int y1 = pos.m_123342_();
        int z1 = pos.m_123343_();
        int x2 = x1;
        int y2 = y1;
        int z2 = z1;
        for (i = 1; i < (Integer)BuilderConfiguration.maxSpaceChamberDimension.get(); ++i) {
            if (x2 == x1) {
                if (this.m_58904_().m_8055_(new BlockPos(x1 - i, y1, z1)).m_60734_() == BuilderModule.SPACE_CHAMBER.get()) {
                    x2 = x1 - i;
                } else if (this.f_58857_.m_8055_(new BlockPos(x1 + i, y1, z1)).m_60734_() == BuilderModule.SPACE_CHAMBER.get()) {
                    x2 = x1 + i;
                }
            }
            if (z2 != z1) continue;
            if (this.f_58857_.m_8055_(new BlockPos(x1, y1, z1 - i)).m_60734_() == BuilderModule.SPACE_CHAMBER.get()) {
                z2 = z1 - i;
                continue;
            }
            if (this.f_58857_.m_8055_(new BlockPos(x1, y1, z1 + i)).m_60734_() != BuilderModule.SPACE_CHAMBER.get()) continue;
            z2 = z1 + i;
        }
        if (x1 == x2 || z2 == z1) {
            Logging.message((Player)player, (String)(ChatFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.f_58857_.m_8055_(new BlockPos(x2, y1, z2)).m_60734_() != BuilderModule.SPACE_CHAMBER.get()) {
            Logging.message((Player)player, (String)(ChatFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        for (i = 1; i < (Integer)BuilderConfiguration.maxSpaceChamberDimension.get(); ++i) {
            if (this.f_58857_.m_8055_(new BlockPos(x1, y1 - i, z1)).m_60734_() == BuilderModule.SPACE_CHAMBER.get()) {
                y2 = y1 - i;
                break;
            }
            if (this.f_58857_.m_8055_(new BlockPos(x1, y1 + i, z1)).m_60734_() != BuilderModule.SPACE_CHAMBER.get()) continue;
            y2 = y1 + i;
            break;
        }
        if (y1 == y2) {
            Logging.message((Player)player, (String)(ChatFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.f_58857_.m_8055_(new BlockPos(x2, y2, z2)).m_60734_() != BuilderModule.SPACE_CHAMBER.get()) {
            Logging.message((Player)player, (String)(ChatFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.f_58857_.m_8055_(new BlockPos(x1, y2, z2)).m_60734_() != BuilderModule.SPACE_CHAMBER.get()) {
            Logging.message((Player)player, (String)(ChatFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        if (this.f_58857_.m_8055_(new BlockPos(x2, y2, z1)).m_60734_() != BuilderModule.SPACE_CHAMBER.get()) {
            Logging.message((Player)player, (String)(ChatFormatting.RED + "Not a valid chamber shape!"));
            return;
        }
        this.minCorner = new BlockPos(Math.min(x1, x2) + 1, Math.min(y1, y2) + 1, Math.min(z1, z2) + 1);
        this.maxCorner = new BlockPos(Math.max(x1, x2) - 1, Math.max(y1, y2) - 1, Math.max(z1, z2) - 1);
        if (this.minCorner.m_123341_() > this.maxCorner.m_123341_() || this.minCorner.m_123342_() > this.maxCorner.m_123342_() || this.minCorner.m_123343_() > this.maxCorner.m_123343_()) {
            Logging.message((Player)player, (String)(ChatFormatting.RED + "Chamber is too small!"));
            this.minCorner = null;
            this.maxCorner = null;
            return;
        }
        Logging.message((Player)player, (String)(ChatFormatting.WHITE + "Chamber succesfully created!"));
        SpaceChamberRepository chamberRepository = SpaceChamberRepository.get(this.f_58857_);
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = chamberRepository.getOrCreateChannel(this.channel);
        chamberChannel.setDimension((ResourceKey<Level>)this.f_58857_.m_46472_());
        chamberChannel.setMinCorner(this.minCorner);
        chamberChannel.setMaxCorner(this.maxCorner);
        chamberRepository.save();
        this.m_6596_();
    }

    public int getChannel() {
        return this.channel;
    }

    public int getChamberSize() {
        if (this.channel == -1) {
            return -1;
        }
        if (this.minCorner == null) {
            return -1;
        }
        return (this.maxCorner.m_123341_() - this.minCorner.m_123341_()) * (this.maxCorner.m_123342_() - this.minCorner.m_123342_()) * (this.maxCorner.m_123343_() - this.minCorner.m_123343_());
    }

    public void setChannel(int channel) {
        this.channel = channel;
        this.m_6596_();
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.minCorner = BlockPosTools.read((CompoundTag)tagCompound, (String)"minCorner");
        this.maxCorner = BlockPosTools.read((CompoundTag)tagCompound, (String)"maxCorner");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        BlockPosTools.write((CompoundTag)tagCompound, (String)"minCorner", (BlockPos)this.minCorner);
        BlockPosTools.write((CompoundTag)tagCompound, (String)"maxCorner", (BlockPos)this.maxCorner);
    }
}

