/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.GameMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adfinders.finder.Indicator;
import com.endertech.minecraft.mods.adfinders.finder.TargetLocation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Needle
extends Indicator {
    public static final float OFFSET = 0.001f;
    public static final Comparator<Needle> SORTING_COMPARATOR = (t1, t2) -> t1.equals(t2) ? 0 : -Double.compare(t1.getTargetLocation().distance, t2.getTargetLocation().distance);

    public Needle(ColorARGB color, TargetLocation location) {
        super(color, location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(VertexConsumer builder, PoseStack matrix, CommonMath.Angle angle, float length, float width) {
        matrix.m_85836_();
        matrix.m_85845_(Vector3f.f_122227_.m_122270_((float)angle.getRadians()));
        float sL = length;
        float sW = width / 2.0f;
        this.addVertex(builder, matrix, -sW, -sL / 5.0f, 0.0f, 0.0f);
        this.addVertex(builder, matrix, sW, -sL / 5.0f, 1.0f, 0.0f);
        this.addVertex(builder, matrix, sW, sL, 1.0f, 1.0f);
        this.addVertex(builder, matrix, -sW, sL, 0.0f, 1.0f);
        matrix.m_85849_();
    }

    public CommonMath.Angle getAngle(Vect3d startPos, float rotationYaw) {
        Vect3d targetPos = GameWorld.getBlockCenter((BlockPos)this.getTargetLocation().position);
        Vect3d delta = startPos.subtract(targetPos);
        return CommonMath.Angle.fromDegrees((double)(rotationYaw - 90.0f - GameMath.arcTan((double)delta.z, (double)delta.x)));
    }
}

