/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adfinders.finder.Definitions;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.init.FinderType;
import com.endertech.minecraft.mods.adfinders.init.Items;
import com.endertech.minecraft.mods.adfinders.init.Targets;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import com.endertech.minecraft.mods.adfinders.items.SyncClientMsg;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod(value="adfinders")
public class AdFinders
extends AbstractForgeMod {
    public static final String ID = "adfinders";
    private static AdFinders instance;
    public final ExecutorService executors;
    public final Items items;

    public static AdFinders getInstance() {
        return instance;
    }

    public AdFinders() {
        instance = this;
        int nThreads = Math.min(4, Runtime.getRuntime().availableProcessors());
        this.executors = Executors.newFixedThreadPool(nThreads);
        this.items = new Items(this);
        this.registerCommonConfig();
        this.registerClientConfig();
        this.getForgeEventBus().addListener(this::onPlayerLoggedIn);
    }

    public String getId() {
        return ID;
    }

    public void commonInit() {
        this.registerNetMessage(FinderState.UpdateMsg::new);
        this.registerNetMessage(SyncClientMsg::new);
    }

    public void commonPostInit() {
        this.loadTargets();
        super.commonPostInit();
    }

    public void configUpdated(ModConfig config) {
        if (config.getType() == ModConfig.Type.COMMON) {
            this.syncWithAllPlayers();
        }
    }

    public void tagsUpdated() {
        this.loadTargets();
        this.syncWithAllPlayers();
    }

    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            this.syncWith((ServerPlayer)player);
        }
    }

    public void loadTargets() {
        for (FinderType type : FinderType.values()) {
            ((Definitions)type.definitions.get()).clear();
        }
        Targets.initAll();
        for (FinderType type : FinderType.values()) {
            ((Definitions)type.definitions.get()).syncWithConfigs();
        }
    }

    public void syncWith(ServerPlayer player) {
        for (FinderType finder : FinderType.values()) {
            SyncClientMsg message = new SyncClientMsg(finder);
            this.getConnection().sendToPlayer((Object)message, player);
        }
    }

    public void registerCommands(ServerCommand command, CommandBuildContext buildContext) {
        command.requires(ServerCommand.OpLevel.NORMAL);
        command.task("reload").executes(context -> {
            this.loadTargets();
            this.syncWithAllPlayers();
        }, "targets");
        command.register();
    }

    public void syncWithAllPlayers() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.m_6846_().m_11314_().forEach(this::syncWith);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
    }

    public void commonConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        for (FinderType type : FinderType.values()) {
            value.push(type.getCategoryName());
            type.scanRadius = value.comment("How far from a player in horizontal plane ores can be found").defineInRange("scanRadius", type.props.scanRadius, Finder.SEARCH_BOUNDS);
            type.pingDepth = value.comment("How far from a player in vertical plane ore veins can be found").defineInRange("pingDepth", type.props.pingDepth, IntBounds.between((Integer)1, (Integer)384));
            type.veinMinSize = value.comment("Minimal size of an ore vein to be found").defineInRange("veinMinSize", type.props.veinMinSize, IntBounds.between((Integer)1, (Integer)128));
            type.depositMinSize = value.comment("Minimal size of an ore deposit to get alarm").defineInRange("depositMinSize", type.props.depositMinSize, IntBounds.between((Integer)1, (Integer)1024));
            type.durability = value.comment("How many hits the finder can withstand").defineInRange("durability", type.props.durability, GameBounds.DURABILITY.getIntBounds());
            type.allowedTargets = value.comment("List of allowed targets. If set, forbidden targets will be ignored").defineList("allowedTargets", new String[0], UnitId.PATTERN.asMatchPredicate());
            type.forbiddenTargets = value.comment("List of forbidden targets").defineList("forbiddenTargets", new String[0], UnitId.PATTERN.asMatchPredicate());
            value.pop();
        }
    }

    public void clientConfigInit(AbstractForgeMod.ConfigValueBuilder value) {
        for (FinderType type : FinderType.values()) {
            value.push(type.getCategoryName());
            type.nameColor = value.comment("Color of the finder's name").defineEnum("nameColor", (Enum)type.props.nameColor);
            type.needleLength = value.comment("Length of the needle indicators").defineInRange("needleLength", 0.35f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0f)));
            type.needleWidth = value.comment("Width of the needle indicators").defineInRange("needleWidth", 0.1f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0f)));
            type.arrowSize = value.comment("Size of the arrow indicators").defineInRange("arrowSize", 0.2f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(1.0f)));
            value.pop();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientRegisterItemModelProperties(ItemModel.Properties<?> props) {
        for (FinderType type : FinderType.values()) {
            props.register((Item)type.finder.get(), "broken", (stack, world, entity) -> ForgeItem.isBroken((ItemStack)stack) ? 1.0f : 0.0f);
            props.register((Item)type.finder.get(), "alarmed", (stack, world, entity) -> Finder.findStateFor(stack).map(state -> Float.valueOf(ForgeItem.notBroken((ItemStack)stack) && state.isDepositFound() ? 1.0f : 0.0f)).orElse(Float.valueOf(0.0f)).floatValue());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
        for (FinderType type : FinderType.values()) {
            registry.replaceModelOf((Item)type.finder.get(), ItemModel.BuiltIn::new);
        }
    }
}

