/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.cookingforblockheads.block.CornerBlock;
import net.blay09.mods.cookingforblockheads.block.CounterBlock;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.util.TextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BlockKitchen
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LOWERED = BooleanProperty.m_61465_((String)"lowered");
    public static final BooleanProperty FLIPPED = BooleanProperty.m_61465_((String)"flipped");
    public static final BooleanProperty HAS_COLOR = BooleanProperty.m_61465_((String)"has_color");
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.m_61587_((String)"color", DyeColor.class);
    private static final VoxelShape BOUNDING_BOX_X = Block.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)15.5, (double)15.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_Z = Block.m_49796_((double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)15.0, (double)15.5);
    private final ResourceLocation registryName;

    protected BlockKitchen(BlockBehaviour.Properties properties, ResourceLocation registryName) {
        super(properties);
        this.registryName = registryName;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X) {
            return BOUNDING_BOX_X;
        }
        return BOUNDING_BOX_Z;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
        if (state.m_61138_((Property)LOWERED)) {
            state = (BlockState)state.m_61124_((Property)LOWERED, (Comparable)Boolean.valueOf(BlockKitchen.shouldBeLoweredUpon(context.m_43725_().m_8055_(context.m_8083_().m_7495_()))));
        }
        return state.m_61138_((Property)HAS_COLOR) ? (BlockState)state.m_61124_((Property)HAS_COLOR, (Comparable)Boolean.valueOf(false)) : state;
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:multiblock_kitchen", ChatFormatting.YELLOW));
        if (this.hasTooltipDescription()) {
            for (String s : I18n.m_118938_((String)("tooltip." + this.registryName + ".description"), (Object[])new Object[0]).split("\\\\n")) {
                tooltip.add(TextUtils.coloredTextComponent(s, ChatFormatting.GRAY));
            }
        }
        if (this.isDyeable()) {
            tooltip.add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:dyeable", ChatFormatting.AQUA));
        }
    }

    protected boolean hasTooltipDescription() {
        return true;
    }

    protected boolean isDyeable() {
        return false;
    }

    public static boolean shouldBlockRenderLowered(BlockGetter world, BlockPos pos) {
        return BlockKitchen.shouldBeLoweredUpon(world.m_8055_(pos.m_7495_()));
    }

    private static boolean shouldBeLoweredUpon(BlockState stateBelow) {
        Block blockBelow = stateBelow.m_60734_();
        return blockBelow instanceof CounterBlock || blockBelow instanceof CornerBlock;
    }

    public boolean shouldBePlacedFlipped(BlockPlaceContext context, Direction facing) {
        BlockPos pos = context.m_8083_();
        Player placer = context.m_43723_();
        if (placer == null) {
            return Math.random() < 0.5;
        }
        double dir = 0.0;
        if (facing.m_122434_() == Direction.Axis.Z) {
            dir = (double)((float)pos.m_123341_() + 0.5f) - placer.m_20185_();
            dir *= -1.0;
        } else if (facing.m_122434_() == Direction.Axis.X) {
            dir = (double)((float)pos.m_123343_() + 0.5f) - placer.m_20189_();
        }
        boolean flipped = facing.m_122421_() == Direction.AxisDirection.POSITIVE ? dir < 0.0 : dir > 0.0;
        return flipped;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BalmContainerProvider) {
            BalmContainerProvider containerProvider = (BalmContainerProvider)blockEntity;
            if (!state.m_60713_(newState.m_60734_())) {
                containerProvider.dropItems(level, pos);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public boolean tryRecolorBlock(BlockState state, ItemStack heldItem, Level level, BlockPos pos, Player player, BlockHitResult rayTraceResult) {
        if (heldItem.m_41720_() == Items.f_42499_ && this.removeColor(state, (LevelAccessor)level, pos, rayTraceResult.m_82434_())) {
            if (!player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            return true;
        }
        DyeColor color = Balm.getHooks().getColor(heldItem);
        if (color != null) {
            if (this.recolorBlock(state, (LevelAccessor)level, pos, rayTraceResult.m_82434_(), color) && !player.m_150110_().f_35937_) {
                heldItem.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    private boolean removeColor(BlockState state, LevelAccessor world, BlockPos pos, Direction facing) {
        if (state.m_61138_(COLOR) && state.m_61138_((Property)HAS_COLOR) && ((Boolean)state.m_61143_((Property)HAS_COLOR)).booleanValue()) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_COLOR, (Comparable)Boolean.valueOf(false)), 3);
            return true;
        }
        return false;
    }

    protected boolean recolorBlock(BlockState state, LevelAccessor world, BlockPos pos, Direction facing, DyeColor color) {
        DyeColor current;
        if (state.m_61138_(COLOR) && state.m_61138_((Property)HAS_COLOR) && ((current = (DyeColor)state.m_61143_(COLOR)) != color || !((Boolean)state.m_61143_((Property)HAS_COLOR)).booleanValue())) {
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_(COLOR, (Comparable)color)).m_61124_((Property)HAS_COLOR, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && state.m_61138_((Property)LOWERED)) {
            return (BlockState)state.m_61124_((Property)LOWERED, (Comparable)Boolean.valueOf(BlockKitchen.shouldBeLoweredUpon(facingState)));
        }
        return state;
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity != null) {
            return tileEntity.m_7531_(id, param);
        }
        return false;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof IMutableNameable) {
            ((IMutableNameable)blockEntity).setCustomName(itemStack.m_41611_());
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

