/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.world;

import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class WorldTesseractData
extends SavedData {
    public static final String TESSERACTS = "botanicadds_tesseracts";
    protected final Object2IntArrayMap<String> channelStorage = new Object2IntArrayMap();

    public WorldTesseractData() {
    }

    public int getMana(String channel) {
        return this.channelStorage.getInt((Object)channel);
    }

    public void setMana(String channel, int mana) {
        if ((long)mana <= 0L) {
            this.channelStorage.removeInt((Object)channel);
        } else {
            this.channelStorage.put((Object)channel, mana);
        }
        this.m_77762_();
    }

    public int getMaxManaPerChannel(String channel) {
        return 1000000;
    }

    public int storeMana(String channel, int amount, IFluidHandler.FluidAction action) {
        int mn = this.getMana(channel);
        int accept = Math.min(this.getMaxManaPerChannel(channel) - mn, Math.abs(amount));
        if (accept > 0 && action.execute()) {
            this.setMana(channel, mn + accept);
        }
        return accept;
    }

    public int takeMana(String channel, int amount, IFluidHandler.FluidAction action) {
        int mn = this.getMana(channel);
        int extract = Math.min(mn, Math.abs(amount));
        if (extract > 0 && action.execute()) {
            this.setMana(channel, mn - extract);
        }
        return extract;
    }

    public WorldTesseractData(CompoundTag tag) {
        ListTag chStLst = tag.m_128437_("Mana", 10);
        for (int i = 0; i < chStLst.size(); ++i) {
            CompoundTag e = chStLst.m_128728_(i);
            this.channelStorage.put((Object)e.m_128461_("Channel"), e.m_128451_("Mana"));
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag chStLst = new ListTag();
        for (Object2IntMap.Entry e : this.channelStorage.object2IntEntrySet()) {
            CompoundTag ct = new CompoundTag();
            ct.m_128359_("Channel", (String)e.getKey());
            ct.m_128356_("Mana", (long)e.getIntValue());
            chStLst.add((Object)ct);
        }
        tag.m_128365_("Mana", (Tag)chStLst);
        return tag;
    }

    public static Optional<WorldTesseractData> forServer(Level level) {
        if (!(level instanceof ServerLevel)) {
            return Optional.empty();
        }
        ServerLevel sl = (ServerLevel)level;
        ServerLevel over = sl.m_7654_().m_129783_();
        WorldTesseractData wtd = (WorldTesseractData)over.m_8895_().m_164858_(WorldTesseractData::new, TESSERACTS);
        if (wtd == null) {
            wtd = new WorldTesseractData();
            over.m_8895_().m_164855_(TESSERACTS, (SavedData)wtd);
        }
        return Optional.of(wtd);
    }

    public static enum TesseractMode implements StringRepresentable
    {
        SEND("send"),
        RECEIVE("receive");

        final String key;
        private static final Supplier<Map<String, TesseractMode>> LOOKUP_TABLE;

        private TesseractMode(String key) {
            this.key = key;
        }

        public boolean shouldAcceptMana() {
            return this == RECEIVE;
        }

        public boolean shouldEmitMana() {
            return this == SEND;
        }

        public String m_7912_() {
            return this.key;
        }

        public static TesseractMode bySerializedName(String key) {
            return LOOKUP_TABLE.get().get(key);
        }

        static {
            LOOKUP_TABLE = Suppliers.memoize(() -> (Map)Util.m_137469_(new HashMap(), m -> {
                for (TesseractMode v : TesseractMode.values()) {
                    m.put(v.m_7912_(), v);
                }
            }));
        }
    }
}

