/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.tiles.flowers;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationListener;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.api.GenerationalFlowerHUD;
import org.zeith.botanicadds.blocks.flowers.VibrantiaBlock;
import org.zeith.botanicadds.init.FlowersBA;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.internal.ManaBurst;

@GenerationalFlowerHUD
public class Vibrantia
extends GeneratingFlowerBlockEntity
implements VibrationListener.VibrationListenerConfig {
    protected int lastVibrationFrequency;
    protected boolean hasOvergrownSoil;
    protected int activeTicks;
    protected VibrationListener listener;

    public Vibrantia(BlockPos pos, BlockState state) {
        super(FlowersBA.VIBRANTIA_TYPE, pos, state);
        this.listener = new VibrationListener((PositionSource)new BlockPositionSource(this.f_58858_), 8, (VibrationListener.VibrationListenerConfig)this, null, 0.0f, 0);
    }

    public VibrationListener getListener() {
        return this.listener;
    }

    public void tickFlower() {
        super.tickFlower();
        if (!this.f_58857_.f_46443_) {
            this.listener.m_157898_(this.f_58857_);
        }
        this.hasOvergrownSoil = this.overgrowth;
        if (this.activeTicks > 0 && !this.overgrowthBoost) {
            long ticksExisted = this.f_58857_.m_46467_();
            if (this.hasOvergrownSoil && ticksExisted % 3L != 0L || ticksExisted % 4L == 0L) {
                this.addMana(1);
                this.sync();
            }
            --this.activeTicks;
        }
    }

    public boolean isOvergrowthAffected() {
        return false;
    }

    public int getMaxMana() {
        return this.hasOvergrownSoil ? 2000 : 1000;
    }

    public int getColor() {
        return 1930633;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.f_58858_, 8.0);
    }

    public boolean m_213734_() {
        return true;
    }

    public boolean m_213641_(ServerLevel level, GameEventListener listener, BlockPos pos, GameEvent event, @Nullable GameEvent.Context context) {
        if (context != null && context.f_223711_() instanceof ManaBurst) {
            return false;
        }
        if (event == GameEvent.f_157778_ && (context == null || context.f_223711_() == null)) {
            return false;
        }
        return !this.m_58901_() && (!pos.equals((Object)this.m_58899_()) || event != GameEvent.f_157794_ && event != GameEvent.f_157797_) && SculkSensorBlock.m_154487_((BlockState)this.m_58900_()) == SculkSensorPhase.INACTIVE;
    }

    public void m_213991_(ServerLevel level, GameEventListener listener, BlockPos pos, GameEvent event, @Nullable Entity ent, @Nullable Entity ent2, float dist) {
        if (ent instanceof ManaBurst) {
            return;
        }
        if (event == GameEvent.f_157778_ && ent == null && ent2 == null) {
            return;
        }
        BlockState blockstate = this.m_58900_();
        if (SculkSensorBlock.m_154489_((BlockState)blockstate)) {
            this.lastVibrationFrequency = SculkSensorBlock.f_222121_.getInt((Object)event);
            this.activeTicks = 40;
            VibrantiaBlock.activate(ent, (Level)level, this.f_58858_, blockstate);
        }
    }

    public void m_214037_() {
        this.m_6596_();
    }
}

