/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.tiles.flowers;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.api.FunctionalFlowerHUD;
import org.zeith.botanicadds.init.FlowersBA;
import org.zeith.hammerlib.util.java.Cast;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;

@FunctionalFlowerHUD
public class Necroidus
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 3;

    public Necroidus(BlockPos pos, BlockState state) {
        super(FlowersBA.NECROIDUS_TYPE, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.getMana() >= 100 && this.ticksExisted % 10 == 0 && !this.f_58857_.f_46443_ && this.redstoneSignal <= 0) {
            int slowdown = 0;
            for (ItemEntity item : this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_).m_82400_((double)this.getRange()))) {
                SkullBlockEntity te;
                BlockState bl;
                BlockState cs;
                ItemStack stack;
                if (item.m_32059_() < 19 + slowdown || item.m_213877_() || (stack = item.m_32055_()).m_41619_() || !stack.m_150930_(Items.f_42049_) && !stack.m_150930_(Items.f_42679_)) continue;
                BlockPos starting = this.f_58858_;
                int steps = 0;
                while (!((cs = this.f_58857_.m_8055_(starting)).m_60734_() == Blocks.f_50016_ && this.f_58857_.m_8055_(starting.m_7494_()).m_60713_(Blocks.f_50016_) && this.f_58857_.m_8055_(starting.m_6630_(2)).m_60713_(Blocks.f_50016_) || cs.m_60734_() == Blocks.f_50135_)) {
                    starting = starting.m_7494_();
                    if (++steps <= 5) continue;
                    return;
                }
                BlockPos soulSandPos = null;
                BlockPos skullPos = null;
                for (int i = 0; i < 2; ++i) {
                    BlockPos cp2;
                    BlockState tile;
                    BlockPos cp = starting.m_6630_(i);
                    if (this.f_58857_.m_8055_(cp).m_60795_()) {
                        soulSandPos = cp;
                        break;
                    }
                    if (i != 1 || !(tile = this.f_58857_.m_8055_(cp2 = starting.m_6630_(2))).m_60713_(Blocks.f_50016_)) continue;
                    skullPos = cp2;
                }
                boolean xValid = true;
                boolean zValid = true;
                if (soulSandPos == null) {
                    BlockPos cp;
                    int i;
                    for (i = 0; i < 3; i += 2) {
                        cp = starting.m_7918_(i - 1, 1, 0);
                        bl = this.f_58857_.m_8055_(cp);
                        if (bl.m_60713_(Blocks.f_50135_) || bl.m_60795_()) continue;
                        xValid = false;
                        break;
                    }
                    for (i = 0; i < 3; i += 2) {
                        cp = starting.m_7918_(0, 1, i - 1);
                        bl = this.f_58857_.m_8055_(cp);
                        if (bl.m_60713_(Blocks.f_50135_) || bl.m_60795_()) continue;
                        zValid = false;
                        break;
                    }
                    if (xValid) {
                        for (i = 0; i < 3; i += 2) {
                            cp = starting.m_7918_(i - 1, 1, 0);
                            bl = this.f_58857_.m_8055_(cp);
                            if (bl.m_60795_()) {
                                soulSandPos = cp;
                                break;
                            }
                            cp2 = starting.m_7918_(i - 1, 2, 0);
                            if (!this.f_58857_.m_8055_(cp2).m_60795_()) continue;
                            skullPos = cp2;
                        }
                    } else if (zValid) {
                        for (i = 0; i < 3; i += 2) {
                            cp = starting.m_7918_(0, 1, i - 1);
                            bl = this.f_58857_.m_8055_(cp);
                            if (bl.m_60795_()) {
                                soulSandPos = cp;
                                break;
                            }
                            cp2 = starting.m_7918_(0, 2, i - 1);
                            if (!this.f_58857_.m_8055_(cp2).m_60795_()) continue;
                            skullPos = cp2;
                        }
                    }
                }
                if (stack.m_150930_(Items.f_42049_) && soulSandPos != null) {
                    stack.m_41774_(1);
                    this.f_58857_.m_46597_(soulSandPos, Blocks.f_50135_.m_49966_());
                    SoundType st = this.f_58857_.m_8055_(soulSandPos).getSoundType((LevelReader)this.f_58857_, soulSandPos, null);
                    bl = this.f_58857_;
                    if (bl instanceof ServerLevel) {
                        ServerLevel sl = (ServerLevel)bl;
                        sl.m_5594_(null, soulSandPos, st.m_56777_(), SoundSource.BLOCKS, (st.m_56773_() + 1.0f) / 2.0f, st.m_56774_() * 0.8f);
                    }
                    this.addMana(-100);
                    this.sync();
                    return;
                }
                if (stack.m_150930_(Items.f_42049_) || skullPos == null || !xValid && !zValid) continue;
                BlockState state = (BlockState)Blocks.f_50312_.m_49966_().m_61124_((Property)SkullBlock.f_56314_, (Comparable)Integer.valueOf(0));
                this.f_58857_.m_46597_(skullPos, state);
                SoundType st = this.f_58857_.m_8055_(skullPos).getSoundType((LevelReader)this.f_58857_, skullPos, null);
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    sl.m_5594_(null, skullPos, st.m_56777_(), SoundSource.BLOCKS, (st.m_56773_() + 1.0f) / 2.0f, st.m_56774_() * 0.8f);
                }
                if ((te = (SkullBlockEntity)Cast.cast((Object)this.f_58857_.m_7702_(skullPos), SkullBlockEntity.class)) == null) {
                    te = new SkullBlockEntity(skullPos, state);
                    this.f_58857_.m_151523_((BlockEntity)te);
                }
                stack.m_41774_(1);
                this.addMana(-100);
                this.sync();
                WitherSkullBlock.m_58255_((Level)this.f_58857_, (BlockPos)skullPos, (SkullBlockEntity)te);
                return;
            }
        }
    }

    public boolean isOvergrowthAffected() {
        return false;
    }

    public int getRange() {
        return 3;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)this.getRange());
    }

    public int getMaxMana() {
        return 700;
    }

    public int getColor() {
        return 0x1B1B1B;
    }

    public boolean acceptsRedstone() {
        return true;
    }
}

