/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.tiles.flowers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.api.GenerationalFlowerHUD;
import org.zeith.botanicadds.init.FlowersBA;
import org.zeith.botanicadds.net.PacketSpawnEnergizeraFX;
import org.zeith.botanicadds.tiles.TileElvenFluxField;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.util.colors.ColorHelper;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.WispParticleData;

@GenerationalFlowerHUD
public class Energizera
extends GeneratingFlowerBlockEntity {
    public static final String TAG_COOLDOWN = "cooldown";
    public static final String TAG_SOURCE = "source";
    public int cooldown;
    public int prevCooldown;
    public BlockPos lastSuccessfulPos;

    public Energizera(BlockPos pos, BlockState state) {
        super(FlowersBA.ENERGIZERA_TYPE, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.cooldown > 0) {
            int reduce = Math.min(2, this.cooldown);
            this.cooldown -= reduce;
            if (!this.f_58857_.f_46443_) {
                this.addMana(reduce);
                this.sync();
            }
            int rgb = this.getColor();
            WispParticleData data = WispParticleData.wisp((float)((float)Math.random() / 6.0f), (float)ColorHelper.getRed((int)rgb), (float)ColorHelper.getGreen((int)rgb), (float)ColorHelper.getBlue((int)rgb), (float)1.0f);
            this.emitParticle((ParticleOptions)data, 0.5 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.0, (float)Math.random() / 30.0f, 0.0);
            this.prevCooldown = this.cooldown;
            return;
        }
        if (!this.f_58857_.f_46443_ && this.getMana() < this.getMaxMana()) {
            for (int i = 0; i < 8; ++i) {
                RandomSource rng = this.f_58857_.f_46441_;
                BlockPos pos = this.lastSuccessfulPos != null ? this.lastSuccessfulPos : this.f_58858_.m_7918_(rng.m_216339_(-4, 4), rng.m_216339_(-2, 2), rng.m_216339_(-4, 4));
                BlockEntity be = this.f_58857_.m_7702_(pos);
                if (be != null) {
                    IEnergyStorage fe = null;
                    for (Direction dir : Direction.values()) {
                        IEnergyStorage fe0 = (IEnergyStorage)be.getCapability(ForgeCapabilities.ENERGY, dir).orElse(null);
                        if (fe0 == null || !fe0.canExtract() || !((double)fe0.getEnergyStored() >= TileElvenFluxField.BOTANIA_MANA.toFE)) continue;
                        fe = fe0;
                        this.lastSuccessfulPos = pos;
                        break;
                    }
                    if (fe != null) {
                        int canAcceptMana = this.getMaxMana() - this.getMana();
                        int canAcceptFE = (int)TileElvenFluxField.BOTANIA_MANA.getInFE((double)canAcceptMana);
                        int canTakeFE = fe.extractEnergy(canAcceptFE, true);
                        canTakeFE = (int)((double)canTakeFE - (double)canTakeFE % TileElvenFluxField.BOTANIA_MANA.toFE);
                        int addMana = (int)TileElvenFluxField.BOTANIA_MANA.getFromFE((double)canTakeFE);
                        fe.extractEnergy(canAcceptFE, false);
                        this.cooldown += addMana;
                        Vec3 start = this.f_58857_.m_8055_(this.lastSuccessfulPos).m_60808_((BlockGetter)this.f_58857_, this.lastSuccessfulPos).m_83215_().m_82338_(this.lastSuccessfulPos).m_82399_();
                        Vec3 end = this.f_58857_.m_8055_(this.f_58858_).m_60808_((BlockGetter)this.f_58857_, this.f_58858_).m_83215_().m_82338_(this.f_58858_).m_82399_().m_82520_(0.0, (double)0.2f, 0.0);
                        Network.sendToTracking((BlockEntity)this, (IPacket)new PacketSpawnEnergizeraFX(start, end));
                        this.sync();
                        break;
                    }
                    if (this.lastSuccessfulPos != pos) continue;
                    this.lastSuccessfulPos = null;
                    continue;
                }
                if (this.lastSuccessfulPos != pos) continue;
                this.lastSuccessfulPos = null;
            }
        }
    }

    public int getMaxMana() {
        return 100;
    }

    public int getColor() {
        return 15679552;
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_COOLDOWN, this.cooldown);
        if (this.lastSuccessfulPos != null) {
            cmp.m_128365_(TAG_SOURCE, (Tag)NbtUtils.m_129224_((BlockPos)this.lastSuccessfulPos));
        }
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.m_128451_(TAG_COOLDOWN);
        this.lastSuccessfulPos = cmp.m_128425_(TAG_SOURCE, 10) ? NbtUtils.m_129239_((CompoundTag)cmp.m_128469_(TAG_SOURCE)) : null;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.f_58858_, (int)4);
    }
}

