/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.blocks;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.botanicadds.BotanicAdditions;
import org.zeith.botanicadds.init.TilesBA;
import org.zeith.botanicadds.tiles.TileDreamingPool;
import org.zeith.hammerlib.api.blocks.ICreativeTabBlock;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.block.decor.BotaniaMushroomBlock;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.item.material.MysticalPetalItem;

public class BlockDreamingPool
extends BotaniaWaterloggedBlock
implements EntityBlock,
ICreativeTabBlock {
    private static final VoxelShape NORMAL_SHAPE;
    private static final VoxelShape NORMAL_SHAPE_BURST;

    public BlockDreamingPool(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BotaniaStateProperties.OPTIONAL_DYE_COLOR, (Comparable)BotaniaStateProperties.OptionalDyeColor.NONE));
    }

    public List<ItemStack> m_7381_(BlockState p_60537_, LootContext.Builder p_60538_) {
        return List.of(new ItemStack((ItemLike)this));
    }

    public CreativeModeTab getCreativeTab() {
        return BotanicAdditions.TAB;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add((Component)Component.m_237115_((String)"info.botanicadds.dreaming_pool").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x444444)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BotaniaStateProperties.OPTIONAL_DYE_COLOR});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return NORMAL_SHAPE;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level world, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ManaPoolBlockEntity pool;
        BlockEntity be = world.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        Optional<Object> itemColor = Optional.empty();
        Item item = stack.m_41720_();
        if (item instanceof MysticalPetalItem) {
            MysticalPetalItem petalItem = (MysticalPetalItem)item;
            itemColor = Optional.of(petalItem.color);
        }
        if ((item = Block.m_49814_((Item)stack.m_41720_())) instanceof BotaniaMushroomBlock) {
            BotaniaMushroomBlock mushroomBlock = (BotaniaMushroomBlock)item;
            itemColor = Optional.of(mushroomBlock.color);
        }
        if (itemColor.isPresent() && be instanceof ManaPoolBlockEntity && !itemColor.equals((pool = (ManaPoolBlockEntity)be).getColor())) {
            pool.setColor(itemColor);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (stack.m_150930_(Items.f_42461_) && be instanceof ManaPoolBlockEntity && (pool = (ManaPoolBlockEntity)be).getColor().isPresent()) {
            pool.setColor(Optional.empty());
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext econtext;
        if (context instanceof EntityCollisionContext && (econtext = (EntityCollisionContext)context).m_193113_() instanceof ManaBurstEntity) {
            return NORMAL_SHAPE_BURST;
        }
        return super.m_5939_(state, world, pos, context);
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TileDreamingPool(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockDreamingPool.createTickerHelper(type, TilesBA.DREAMING_POOL, (BlockEntityTicker)(level.f_46443_ ? ManaPoolBlockEntity::clientTick : ManaPoolBlockEntity::serverTick));
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            ManaPoolBlockEntity tile = (ManaPoolBlockEntity)world.m_7702_(pos);
            tile.collideEntityItem(item);
        }
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        ManaPoolBlockEntity pool = (ManaPoolBlockEntity)world.m_7702_(pos);
        return ManaPoolBlockEntity.calculateComparatorLevel((int)pool.getCurrentMana(), (int)pool.getMaxMana());
    }

    static {
        NORMAL_SHAPE_BURST = BlockDreamingPool.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
        VoxelShape cutout = BlockDreamingPool.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        NORMAL_SHAPE = Shapes.m_83113_((VoxelShape)NORMAL_SHAPE_BURST, (VoxelShape)cutout, (BooleanOp)BooleanOp.f_82685_);
    }
}

