/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.api.recipes.botania;

import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.zeith.hammerlib.core.adapter.recipe.RecipeGroup;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.BlockStateIngredient;
import vazkii.botania.common.crafting.BlocksStateIngredient;
import vazkii.botania.common.crafting.PureDaisyRecipe;
import vazkii.botania.common.crafting.TagStateIngredient;

public class PureDaisyRecipeBuilder {
    protected final IRecipeRegistrationEvent<Recipe<?>> event;
    protected ResourceLocation identifier;
    protected String group = "";
    private int time = 1200;
    private StateIngredient input;
    private BlockState output;
    private CommandFunction.CacheableFunction function = CommandFunction.CacheableFunction.f_77990_;

    public PureDaisyRecipeBuilder(IRecipeRegistrationEvent<Recipe<?>> event) {
        this.event = event;
    }

    public PureDaisyRecipeBuilder id(ResourceLocation identifier) {
        this.identifier = identifier;
        return this;
    }

    protected ResourceLocation getIdentifier() {
        if (this.identifier != null) {
            return this.identifier;
        }
        this.identifier = this.event.nextId((Object)this.output.m_60734_().m_5456_());
        return this.identifier;
    }

    public PureDaisyRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public PureDaisyRecipeBuilder group(RecipeGroup group) {
        this.group = group.toString();
        return this;
    }

    public PureDaisyRecipeBuilder time(int time) {
        this.time = time;
        return this;
    }

    public PureDaisyRecipeBuilder input(Block block) {
        this.input = new BlockStateIngredient(block);
        return this;
    }

    public PureDaisyRecipeBuilder input(Block ... block) {
        this.input = new BlocksStateIngredient(List.of(block));
        return this;
    }

    public PureDaisyRecipeBuilder input(Collection<Block> block) {
        this.input = new BlocksStateIngredient(block);
        return this;
    }

    public PureDaisyRecipeBuilder input(TagKey<Block> tag) {
        this.input = new TagStateIngredient(tag.f_203868_());
        return this;
    }

    public PureDaisyRecipeBuilder input(StateIngredient custom) {
        this.input = custom;
        return this;
    }

    public PureDaisyRecipeBuilder result(Block block) {
        this.output = block.m_49966_();
        return this;
    }

    public PureDaisyRecipeBuilder result(BlockState state) {
        this.output = state;
        return this;
    }

    public PureDaisyRecipeBuilder function(CommandFunction.CacheableFunction function) {
        this.function = function;
        return this;
    }

    protected void validate() {
        if (this.input == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have any defined input!");
        }
        if (this.output == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have any defined output!");
        }
    }

    public void register() {
        this.validate();
        ResourceLocation id = this.getIdentifier();
        this.event.register(id, (Object)new PureDaisyRecipe(id, this.input, this.output, this.time, this.function));
    }
}

