/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.botanicadds.api.recipes.botania;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;
import vazkii.botania.common.crafting.ElvenTradeRecipe;

public class ElvenTradeRecipeBuilder {
    protected final IRecipeRegistrationEvent<Recipe<?>> event;
    protected ResourceLocation identifier;
    private NonNullList<Ingredient> inputs = NonNullList.m_122779_();
    private NonNullList<ItemStack> outputs = NonNullList.m_122779_();

    public ElvenTradeRecipeBuilder(IRecipeRegistrationEvent<Recipe<?>> event) {
        this.event = event;
    }

    public ElvenTradeRecipeBuilder id(ResourceLocation identifier) {
        this.identifier = identifier;
        return this;
    }

    protected ResourceLocation getIdentifier() {
        if (this.identifier != null) {
            return this.identifier;
        }
        this.identifier = this.event.nextId((Object)((ItemStack)this.outputs.get(0)).m_41720_());
        return this.identifier;
    }

    public ElvenTradeRecipeBuilder input(Object ... inputs) {
        this.inputs.addAll(Stream.of(inputs).map(RecipeHelper::fromComponent).toList());
        return this;
    }

    public ElvenTradeRecipeBuilder result(ItemStack ... outputs) {
        this.outputs.addAll(List.of(outputs));
        return this;
    }

    public ElvenTradeRecipeBuilder result(ItemLike output) {
        this.outputs.add((Object)new ItemStack(output));
        return this;
    }

    public ElvenTradeRecipeBuilder result(ItemLike output, int count) {
        this.outputs.add((Object)new ItemStack(output, count));
        return this;
    }

    protected void validate() {
        if (this.inputs.isEmpty()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have any defined inputs!");
        }
        if (this.outputs.isEmpty()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have any defined outputs!");
        }
    }

    public void register() {
        this.validate();
        ResourceLocation id = this.getIdentifier();
        this.event.register(id, (Object)new ElvenTradeRecipe(id, (ItemStack[])this.outputs.toArray(ItemStack[]::new), (Ingredient[])this.inputs.toArray(Ingredient[]::new)));
    }
}

