/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.storage.ITerminalHost;
import appeng.menu.MenuOpener;
import appeng.menu.SlotSemantic;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.locator.MenuLocator;
import appeng.menu.me.items.CraftingTermMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.RestrictedInputSlot;
import de.mari_023.ae2wtlib.AE2wtlibSlotSemantics;
import de.mari_023.ae2wtlib.terminal.ArmorSlot;
import de.mari_023.ae2wtlib.wct.WCTMenuHost;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHandler;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetMode;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetSettings;
import de.mari_023.ae2wtlib.wct.magnet_card.config.MagnetMenu;
import de.mari_023.ae2wtlib.wut.ItemWUT;
import java.util.Objects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Wearable;

public class WCTMenu
extends CraftingTermMenu {
    public static final String ID = "wireless_crafting_terminal";
    public static final MenuType<WCTMenu> TYPE = MenuTypeBuilder.create(WCTMenu::new, WCTMenuHost.class).requirePermission(SecurityPermissions.CRAFT).build("wireless_crafting_terminal");
    public static final String ACTION_DELETE = "delete";
    public static final String MAGNET_MODE = "magnetMode";
    public static final String MAGNET_MENU = "magnetMenu";
    private final WCTMenuHost wctMenuHost;
    private MagnetSettings magnetSettings;

    public WCTMenu(int id, Inventory ip, WCTMenuHost gui) {
        super(TYPE, id, ip, (ITerminalHost)gui, true);
        this.wctMenuHost = gui;
        this.addSlot((Slot)new ArmorSlot(this.getPlayerInventory(), ArmorSlot.Armor.HEAD){

            @Override
            public boolean m_5857_(ItemStack stack) {
                BlockItem bItem;
                Item item = stack.m_41720_();
                return item instanceof BlockItem && (bItem = (BlockItem)item).m_40614_() instanceof Wearable || super.m_5857_(stack);
            }
        }, AE2wtlibSlotSemantics.HELMET);
        this.addSlot((Slot)new ArmorSlot(this.getPlayerInventory(), ArmorSlot.Armor.CHEST), AE2wtlibSlotSemantics.CHESTPLATE);
        this.addSlot((Slot)new ArmorSlot(this.getPlayerInventory(), ArmorSlot.Armor.LEGS), AE2wtlibSlotSemantics.LEGGINGS);
        this.addSlot((Slot)new ArmorSlot(this.getPlayerInventory(), ArmorSlot.Armor.FEET), AE2wtlibSlotSemantics.BOOTS);
        if (Integer.valueOf(40).equals(this.wctMenuHost.getSlot())) {
            this.addSlot((Slot)new ArmorSlot.DisabledOffhandSlot(this.getPlayerInventory()), AE2wtlibSlotSemantics.OFFHAND);
        } else {
            this.addSlot((Slot)new ArmorSlot(this.getPlayerInventory(), ArmorSlot.Armor.OFFHAND), AE2wtlibSlotSemantics.OFFHAND);
        }
        this.addSlot((Slot)new AppEngSlot(this.wctMenuHost.getSubInventory(WCTMenuHost.INV_TRASH), 0), AE2wtlibSlotSemantics.TRASH);
        this.addSlot((Slot)new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.QE_SINGULARITY, this.wctMenuHost.getSubInventory(WCTMenuHost.INV_SINGULARITY), 0), AE2wtlibSlotSemantics.SINGULARITY);
        this.registerClientAction(ACTION_DELETE, this::deleteTrashSlot);
        this.registerClientAction(MAGNET_MODE, MagnetMode.class, this::setMagnetMode);
        this.registerClientAction(MAGNET_MENU, this::openMagnetMenu);
    }

    public IGridNode getNetworkNode() {
        return this.wctMenuHost.getActionableNode();
    }

    public boolean useRealItems() {
        return true;
    }

    public void deleteTrashSlot() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_DELETE);
        }
        Objects.requireNonNull(this.wctMenuHost.getSubInventory(WCTMenuHost.INV_TRASH)).setItemDirect(0, ItemStack.f_41583_);
    }

    public MagnetSettings getMagnetSettings() {
        this.magnetSettings = MagnetHandler.getMagnetSettings(this.wctMenuHost.getItemStack());
        return this.magnetSettings;
    }

    public void saveMagnetSettings() {
        MagnetHandler.saveMagnetSettings(this.wctMenuHost.getItemStack(), this.magnetSettings);
    }

    public void setMagnetMode(MagnetMode mode) {
        if (this.isClientSide()) {
            this.sendClientAction(MAGNET_MODE, (Object)mode);
        }
        this.getMagnetSettings().magnetMode = mode;
        this.saveMagnetSettings();
    }

    public void openMagnetMenu() {
        if (this.isClientSide()) {
            this.sendClientAction(MAGNET_MENU);
            return;
        }
        MenuOpener.open(MagnetMenu.TYPE, (Player)this.getPlayer(), (MenuLocator)this.getLocator());
    }

    protected boolean canSlotsBeHidden(SlotSemantic semantic) {
        return semantic == AE2wtlibSlotSemantics.OFFHAND || semantic == AE2wtlibSlotSemantics.HELMET || semantic == AE2wtlibSlotSemantics.CHESTPLATE || semantic == AE2wtlibSlotSemantics.LEGGINGS || semantic == AE2wtlibSlotSemantics.BOOTS || semantic == AE2wtlibSlotSemantics.TRASH;
    }

    public boolean isWUT() {
        return this.wctMenuHost.getItemStack().m_41720_() instanceof ItemWUT;
    }
}

