/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.mixin;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.me.helpers.PlayerSource;
import de.mari_023.ae2wtlib.networking.ServerNetworkManager;
import de.mari_023.ae2wtlib.networking.s2c.UpdateRestockPacket;
import de.mari_023.ae2wtlib.terminal.ItemWT;
import de.mari_023.ae2wtlib.wct.CraftingTerminalHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class Restock {
    @Shadow
    public abstract boolean m_41619_();

    @Shadow
    public abstract void m_41764_(int var1);

    @Shadow
    public abstract int m_41741_();

    @Shadow
    public abstract int m_41613_();

    @Inject(method={"useOn"}, at={@At(value="RETURN")})
    public void useOnBlockRestock(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        if (!context.m_43725_().m_5776_() && ((InteractionResult)cir.getReturnValue()).equals((Object)InteractionResult.CONSUME) && context.m_43723_() != null) {
            this.restock(context.m_43723_());
        }
    }

    @Inject(method={"use"}, at={@At(value="RETURN")})
    public void useRestock(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!world.m_5776_() && ((InteractionResultHolder)cir.getReturnValue()).m_19089_().equals((Object)InteractionResult.CONSUME)) {
            this.restock(user);
        }
    }

    private void restock(Player player) {
        if (this.m_41619_() && !player.m_7500_()) {
            return;
        }
        CraftingTerminalHandler cTHandler = CraftingTerminalHandler.getCraftingTerminalHandler(player);
        if (!cTHandler.inRange() || !ItemWT.getBoolean(cTHandler.getCraftingTerminal(), "restock") || cTHandler.getTargetGrid() == null || cTHandler.getTargetGrid().getStorageService() == null) {
            return;
        }
        int toAdd = this.m_41741_() / 2 - this.m_41613_();
        if (toAdd == 0) {
            return;
        }
        long changed = toAdd > 0 ? cTHandler.getTargetGrid().getStorageService().getInventory().extract((AEKey)AEItemKey.of((ItemStack)((ItemStack)this)), (long)toAdd, Actionable.MODULATE, (IActionSource)new PlayerSource(player, cTHandler.getSecurityStation())) : -cTHandler.getTargetGrid().getStorageService().getInventory().insert((AEKey)AEItemKey.of((ItemStack)((ItemStack)this)), (long)(-toAdd), Actionable.MODULATE, (IActionSource)new PlayerSource(player, cTHandler.getSecurityStation()));
        this.m_41764_(this.m_41613_() + (int)changed);
        ServerNetworkManager.sendToClient((ServerPlayer)player, new UpdateRestockPacket(player.m_150109_().m_36043_((ItemStack)this), this.m_41613_()));
    }
}

