/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.flags;

import cofh.lib.util.Constants;
import cofh.lib.util.flags.FlagLootCondition;
import cofh.lib.util.flags.FlagRecipeCondition;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class FlagManager {
    private static final Object2ObjectOpenHashMap<String, Supplier<Boolean>> FLAGS = new Object2ObjectOpenHashMap(64);
    public final ResourceLocation id;
    public LootItemConditionType flagConditionType;

    public FlagManager(String modId) {
        this(modId, "flag");
    }

    public FlagManager(String modId, String path) {
        this.id = new ResourceLocation(modId, path);
        CraftingHelper.register((IConditionSerializer)new FlagRecipeCondition.Serializer(this, this.id));
        this.flagConditionType = new LootItemConditionType((Serializer)new FlagLootCondition.Serializer(this));
    }

    public void setup() {
        Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)this.id, (Object)this.flagConditionType);
    }

    private Supplier<Boolean> getOrCreateFlag(String flag) {
        FLAGS.putIfAbsent((Object)flag, Constants.FALSE);
        return (Supplier)FLAGS.get((Object)flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlag(String flag, boolean enable) {
        Object2ObjectOpenHashMap<String, Supplier<Boolean>> object2ObjectOpenHashMap = FLAGS;
        synchronized (object2ObjectOpenHashMap) {
            FLAGS.put((Object)flag, enable ? Constants.TRUE : Constants.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlag(String flag, Supplier<Boolean> condition) {
        Object2ObjectOpenHashMap<String, Supplier<Boolean>> object2ObjectOpenHashMap = FLAGS;
        synchronized (object2ObjectOpenHashMap) {
            FLAGS.put((Object)flag, condition == null ? Constants.FALSE : condition);
        }
    }

    public Supplier<Boolean> getFlag(String flag) {
        return () -> this.getOrCreateFlag(flag).get();
    }
}

