/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.panel.InfoPanel;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.client.gui.element.panel.PanelTracker;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class ContainerScreenCoFH<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T>
implements IGuiAccess {
    protected int mX;
    protected int mY;
    protected String name = "";
    protected String info = "";
    protected ResourceLocation texture;
    protected Player player;
    protected boolean drawTitle = true;
    protected boolean drawInventory = true;
    protected boolean showTooltips = true;
    private final ArrayList<PanelBase> panels = new ArrayList();
    private final ArrayList<ElementBase> elements = new ArrayList();
    private final List<Component> tooltip = new LinkedList<Component>();

    public ContainerScreenCoFH(T container, Inventory inv, Component titleIn) {
        super(container, inv, titleIn);
        this.player = inv.f_35978_;
    }

    public void m_7856_() {
        super.m_7856_();
        this.panels.clear();
        this.elements.clear();
        if (this.info != null && !this.info.isEmpty()) {
            this.addPanel(new InfoPanel((IGuiAccess)this, this.info));
        }
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTick) {
        this.mX = mouseX - this.f_97735_;
        this.mY = mouseY - this.f_97736_;
        this.updatePanels();
        this.updateElements();
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTick);
        this.m_7025_(matrixStack, mouseX, mouseY);
        if (this.showTooltips && this.f_97732_.m_142621_().m_41619_()) {
            this.drawTooltip(matrixStack);
        }
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderHelper.setPosTexShader();
        RenderHelper.resetShaderColor();
        RenderHelper.setShaderTexture0(this.texture);
        this.drawTexturedModalRect(matrixStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)this.f_97735_, (double)this.f_97736_, 0.0);
        this.drawPanels(matrixStack, false);
        this.drawElements(matrixStack, false);
        matrixStack.m_85849_();
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        if (this.drawTitle & this.f_96539_ != null) {
            this.fontRenderer().m_92883_(matrixStack, StringHelper.localize(this.f_96539_.getString()), (float)this.getCenteredOffset(StringHelper.localize(this.f_96539_.getString())), 6.0f, 0x404040);
        }
        if (this.drawInventory) {
            this.fontRenderer().m_92883_(matrixStack, StringHelper.localize("container.inventory"), 8.0f, (float)(this.f_97727_ - 96 + 3), 0x404040);
        }
        this.drawPanels(matrixStack, true);
        this.drawElements(matrixStack, true);
    }

    protected void renderSlotGradient(PoseStack matrixStack, Slot slot, int color1, int color2) {
        int x = this.guiLeft() + slot.f_40220_;
        int y = this.guiTop() + slot.f_40221_;
        this.m_93179_(matrixStack, x, y, x + 16, y + 16, color1, color2);
    }

    public void drawTooltip(PoseStack matrixStack) {
        ElementBase element;
        PanelBase panel = this.getPanelAtPosition(this.mX, this.mY);
        if (panel != null) {
            panel.addTooltip(this.tooltip, this.mX, this.mY);
        }
        if ((element = this.getElementAtPosition(this.mX, this.mY)) != null && element.visible()) {
            element.addTooltip(this.tooltip, this.mX, this.mY);
        }
        this.renderTooltip(matrixStack, this.tooltip, Optional.empty(), this.mX + this.f_97735_, this.mY + this.f_97736_, this.f_96547_);
        this.tooltip.clear();
    }

    protected void drawElements(PoseStack matrixStack, boolean foreground) {
        if (foreground) {
            for (ElementBase c : this.elements) {
                if (!c.visible()) continue;
                c.drawForeground(matrixStack, this.mX, this.mY);
            }
        } else {
            for (ElementBase c : this.elements) {
                if (!c.visible()) continue;
                c.drawBackground(matrixStack, this.mX, this.mY);
            }
        }
    }

    protected void drawPanels(PoseStack matrixStack, boolean foreground) {
        int yPosRight = 4;
        int yPosLeft = 4;
        if (foreground) {
            for (PanelBase panel : this.panels) {
                panel.updateSize();
                if (!panel.visible()) continue;
                if (panel.side == 0) {
                    panel.drawForeground(matrixStack, this.mX, this.mY);
                    yPosLeft += panel.height();
                    continue;
                }
                panel.drawForeground(matrixStack, this.mX, this.mY);
                yPosRight += panel.height();
            }
        } else {
            for (PanelBase panel : this.panels) {
                panel.updateSize();
                if (!panel.visible()) continue;
                if (panel.side == 0) {
                    panel.setPosition(0, yPosLeft);
                    panel.drawBackground(matrixStack, this.mX, this.mY);
                    yPosLeft += panel.height();
                    continue;
                }
                panel.setPosition(this.f_97726_, yPosRight);
                panel.drawBackground(matrixStack, this.mX, this.mY);
                yPosRight += panel.height();
            }
        }
    }

    protected <T> T addElement(ElementBase element) {
        this.elements.add(element);
        return (T)element;
    }

    public final void addElements(ElementBase ... c) {
        this.elements.addAll(Arrays.asList(c));
    }

    protected <T> T addPanel(PanelBase panel) {
        int yOffset = 4;
        for (PanelBase panel1 : this.panels) {
            if (panel1.side != panel.side || !panel1.visible()) continue;
            yOffset += panel1.height();
        }
        panel.setPosition(panel.side == 0 ? 0 : this.f_97726_, yOffset);
        this.panels.add(panel);
        if (PanelTracker.getOpenedLeft() != null && panel.getClass().equals(PanelTracker.getOpenedLeft())) {
            panel.setFullyOpen();
        } else if (PanelTracker.getOpenedRight() != null && panel.getClass().equals(PanelTracker.getOpenedRight())) {
            panel.setFullyOpen();
        }
        return (T)panel;
    }

    private ElementBase getElementAtPosition(int mouseX, int mouseY) {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase element = this.elements.get(i);
            if (!element.intersectsWith(mouseX, mouseY) || !element.visible()) continue;
            return element;
        }
        return null;
    }

    private PanelBase getPanelAtPosition(double mouseX, double mouseY) {
        int xShift = 0;
        int yShift = 4;
        for (PanelBase panel : this.panels) {
            if (!panel.visible() || panel.side == 1) continue;
            panel.setShift(xShift, yShift);
            if (panel.intersectsWith(mouseX, mouseY, xShift, yShift)) {
                return panel;
            }
            yShift += panel.height();
        }
        xShift = this.f_97726_;
        yShift = 4;
        for (PanelBase panel : this.panels) {
            if (!panel.visible() || panel.side == 0) continue;
            panel.setShift(xShift, yShift);
            if (panel.intersectsWith(mouseX, mouseY, xShift, yShift)) {
                return panel;
            }
            yShift += panel.height();
        }
        return null;
    }

    private void updateElements() {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled()) continue;
            c.update(this.mX, this.mY);
        }
    }

    private void updatePanels() {
        int i = this.panels.size();
        while (i-- > 0) {
            PanelBase c = this.panels.get(i);
            if (!c.visible() || !c.enabled()) continue;
            c.update(this.mX, this.mY);
        }
    }

    public List<Rect2i> getPanelBounds() {
        ArrayList<Rect2i> panelBounds = new ArrayList<Rect2i>();
        for (PanelBase c : this.panels) {
            panelBounds.add(c.getBoundsOnScreen());
        }
        return panelBounds;
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && this.getPanelAtPosition(mouseX - (double)guiLeftIn, mouseY - (double)guiTopIn) == null;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        mouseX -= (double)this.f_97735_;
        mouseY -= (double)this.f_97736_;
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled() || !c.intersectsWith(mouseX, mouseY) || !c.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        PanelBase panel = this.getPanelAtPosition(mouseX, mouseY);
        if (panel != null && !panel.mouseClicked(mouseX, mouseY, mouseButton)) {
            int i2 = this.panels.size();
            while (i2-- > 0) {
                PanelBase other = this.panels.get(i2);
                if (other == panel || !other.open || other.side != panel.side) continue;
                other.toggleOpen();
            }
            panel.toggleOpen();
            return true;
        }
        if (panel != null) {
            switch (panel.side) {
                case 0: {
                    this.f_97735_ -= panel.width();
                    break;
                }
                case 1: {
                    this.f_97726_ += panel.width();
                }
            }
        }
        boolean ret = super.m_6375_(mouseX += (double)this.f_97735_, mouseY += (double)this.f_97736_, mouseButton);
        if (panel != null) {
            switch (panel.side) {
                case 0: {
                    this.f_97735_ += panel.width();
                    break;
                }
                case 1: {
                    this.f_97726_ -= panel.width();
                }
            }
        }
        return ret;
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        mouseX -= (double)this.f_97735_;
        mouseY -= (double)this.f_97736_;
        if (mouseButton >= 0 && mouseButton <= 2) {
            int i = this.elements.size();
            while (i-- > 0) {
                ElementBase c = this.elements.get(i);
                if (!c.visible() || !c.enabled()) continue;
                c.mouseReleased(mouseX, mouseY);
            }
        }
        return super.m_6348_(mouseX += (double)this.f_97735_, mouseY += (double)this.f_97736_, mouseButton);
    }

    public boolean m_6050_(double mouseX, double mouseY, double movement) {
        if (movement != 0.0) {
            int i = this.elements.size();
            while (i-- > 0) {
                ElementBase c = this.elements.get(i);
                if (!c.visible() || !c.enabled() || !c.intersectsWith(this.mX, this.mY) || !c.mouseWheel(this.mX, this.mY, movement)) continue;
                return true;
            }
            PanelBase panel = this.getPanelAtPosition(this.mX, this.mY);
            if (panel != null && panel.mouseWheel(this.mX, this.mY, movement)) {
                return true;
            }
            return this.mouseWheel(this.mX, this.mY, movement);
        }
        return false;
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.visible() || !c.enabled() || !c.keyTyped(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_)) continue;
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    protected boolean mouseWheel(double mouseX, double mouseY, double movement) {
        return false;
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.f_97726_ / 2);
    }

    protected int getCenteredOffset(String string, int xPos) {
        return (xPos * 2 - this.f_96547_.m_92895_(string)) / 2;
    }

    @Override
    public int guiTop() {
        return this.f_97736_;
    }

    @Override
    public int guiLeft() {
        return this.f_97735_;
    }

    @Override
    public final Font fontRenderer() {
        return this.f_96547_;
    }

    @Override
    public final Player player() {
        return this.player;
    }

    @Override
    public int blitOffset() {
        return this.m_93252_();
    }
}

