/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.CommandPerformEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.latvian.mods.kubejs.bindings.event.LevelEvents;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.command.CommandRegistryEventJS;
import dev.latvian.mods.kubejs.command.KubeJSCommands;
import dev.latvian.mods.kubejs.level.SimpleLevelEventJS;
import dev.latvian.mods.kubejs.server.CommandEventJS;
import dev.latvian.mods.kubejs.server.ScheduledEvent;
import dev.latvian.mods.kubejs.server.ServerEventJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.RhinoException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;

public class KubeJSServerEventHandler {
    private static final LevelResource PERSISTENT_DATA = new LevelResource("kubejs_persistent_data.nbt");

    public static void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(KubeJSServerEventHandler::serverAboutToStart);
        CommandRegistrationEvent.EVENT.register(KubeJSServerEventHandler::registerCommands);
        LifecycleEvent.SERVER_BEFORE_START.register(KubeJSServerEventHandler::serverBeforeStarting);
        LifecycleEvent.SERVER_STARTING.register(KubeJSServerEventHandler::serverStarting);
        LifecycleEvent.SERVER_STOPPING.register(KubeJSServerEventHandler::serverStopping);
        LifecycleEvent.SERVER_STOPPED.register(KubeJSServerEventHandler::serverStopped);
        LifecycleEvent.SERVER_LEVEL_SAVE.register(KubeJSServerEventHandler::serverLevelSaved);
        LifecycleEvent.SERVER_LEVEL_LOAD.register(KubeJSServerEventHandler::serverLevelLoaded);
        CommandPerformEvent.EVENT.register(KubeJSServerEventHandler::command);
    }

    public static void serverAboutToStart(MinecraftServer server) {
        Path p = server.m_129843_(PERSISTENT_DATA);
        if (Files.exists(p, new LinkOption[0])) {
            try {
                CompoundTag tag = NbtIo.m_128937_((File)p.toFile());
                if (tag != null) {
                    server.kjs$getPersistentData().m_128391_(tag);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registry, Commands.CommandSelection selection) {
        KubeJSCommands.register(dispatcher);
        ServerEvents.COMMAND_REGISTRY.post(new CommandRegistryEventJS(dispatcher, registry, selection));
    }

    private static void serverBeforeStarting(MinecraftServer server) {
        UtilsJS.staticServer = server;
    }

    private static void serverStarting(MinecraftServer server) {
        ServerEvents.LOADED.post(new ServerEventJS(server));
    }

    private static void serverStopping(MinecraftServer server) {
        ServerEvents.UNLOADED.post(new ServerEventJS(server));
    }

    private static void serverStopped(MinecraftServer server) {
        UtilsJS.staticServer = null;
    }

    private static void serverLevelLoaded(ServerLevel level) {
        LevelEvents.LOADED.post(level.m_46472_().m_135782_(), new SimpleLevelEventJS((Level)level));
    }

    private static void serverLevelSaved(ServerLevel level) {
        Path p = level.m_7654_().m_129843_(PERSISTENT_DATA);
        if (level.m_46472_() == Level.f_46428_) {
            Util.m_183992_().execute(() -> {
                try {
                    NbtIo.m_128944_((CompoundTag)level.m_7654_().kjs$getPersistentData(), (File)p.toFile());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
    }

    public static void tickScheduledEvents(long now, List<ScheduledEvent> kjs$scheduledEvents) {
        if (!kjs$scheduledEvents.isEmpty()) {
            Iterator<ScheduledEvent> eventIterator = kjs$scheduledEvents.iterator();
            ArrayList<ScheduledEvent> list = new ArrayList<ScheduledEvent>(0);
            while (eventIterator.hasNext()) {
                ScheduledEvent e = eventIterator.next();
                if (now < e.getEndTime()) continue;
                list.add(e);
                eventIterator.remove();
            }
            for (ScheduledEvent e : list) {
                try {
                    e.call();
                }
                catch (RhinoException ex) {
                    ConsoleJS.SERVER.error("Error occurred while handling scheduled event callback: " + ex.getMessage());
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static EventResult command(CommandPerformEvent event) {
        CommandEventJS e = new CommandEventJS(event);
        if (ServerEvents.COMMAND.post(e.getCommandName(), e)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}

