/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.registries.Registrar;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class DataExport {
    @HideFromJS
    public static CommandSourceStack source;
    @HideFromJS
    public static JsonObject dataExport;

    public static void exportData() {
        if (dataExport != null) {
            Util.m_183992_().execute(DataExport::exportDataBlocking);
        }
    }

    private static <T> void addRegistry(JsonObject o, String name, Registrar<T> r) {
        JsonArray a = new JsonArray();
        for (ResourceLocation id : r.getIds()) {
            a.add(id.toString());
        }
        o.add(name, (JsonElement)a);
    }

    private static void exportDataBlocking() {
        JsonObject registries = new JsonObject();
        DataExport.addRegistry(registries, "items", KubeJSRegistries.items());
        DataExport.addRegistry(registries, "blocks", KubeJSRegistries.blocks());
        DataExport.addRegistry(registries, "fluids", KubeJSRegistries.fluids());
        DataExport.addRegistry(registries, "entity_types", KubeJSRegistries.entityTypes());
        dataExport.add("registries", (JsonElement)registries);
        JsonArray errors = new JsonArray();
        for (String string : ScriptType.SERVER.errors) {
            errors.add(string);
        }
        dataExport.add("errors", (JsonElement)errors);
        JsonArray warnings = new JsonArray();
        for (String s : ScriptType.SERVER.warnings) {
            warnings.add(s);
        }
        dataExport.add("warnings", (JsonElement)warnings);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(KubeJSPaths.EXPORTED.resolve("kubejs-server-export.json"), new OpenOption[0]);){
            JsonIO.GSON.toJson((JsonElement)dataExport, (Appendable)bufferedWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        source.m_81354_((Component)Component.m_237113_((String)"Done! Export in kubejs/exported/kubejs-server-export.json"), false);
        source.m_81354_((Component)Component.m_237113_((String)"You can now upload it on ").m_7220_((Component)Component.m_237113_((String)"https://export.kubejs.com/").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE}).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://export.kubejs.com/")))), false);
        source = null;
        dataExport = null;
    }
}

