/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.CommonProperties;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.bindings.event.ServerEvents;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientWithCustomPredicate;
import dev.latvian.mods.kubejs.item.ingredient.TagContext;
import dev.latvian.mods.kubejs.platform.RecipePlatformHelper;
import dev.latvian.mods.kubejs.recipe.IngredientMatch;
import dev.latvian.mods.kubejs.recipe.ItemInputTransformer;
import dev.latvian.mods.kubejs.recipe.ItemOutputTransformer;
import dev.latvian.mods.kubejs.recipe.JsonRecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.MissingRecipeFunctionException;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.RecipeArguments;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeFunction;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.mods.kubejs.recipe.special.SpecialRecipeSerializerManager;
import dev.latvian.mods.kubejs.server.DataExport;
import dev.latvian.mods.kubejs.server.KubeJSReloadListener;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.JsonIO;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class RecipesEventJS
extends EventJS {
    public static final String FORGE_CONDITIONAL = "forge:conditional";
    private static final Pattern SKIP_ERROR = Pattern.compile("at dev.latvian.mods.kubejs.recipe.RecipeEventJS.post");
    public static Map<UUID, IngredientWithCustomPredicate> customIngredientMap = null;
    public static Map<UUID, ModifyRecipeResultCallback> modifyResultCallbackMap = null;
    public static RecipesEventJS instance;
    private final List<Recipe<?>> fallbackedRecipes = new ArrayList();
    private final List<RecipeJS> originalRecipes = new ArrayList<RecipeJS>();
    final List<RecipeJS> addedRecipes;
    private final Set<RecipeJS> removedRecipes;
    private final Set<RecipeJS> modifiedRecipes;
    private final Map<String, Object> recipeFunctions;
    private AtomicInteger modifiedRecipesCount;
    public final RecipeFunction shaped;
    public final RecipeFunction shapeless;
    public final RecipeFunction smelting;
    public final RecipeFunction blasting;
    public final RecipeFunction smoking;
    public final RecipeFunction campfireCooking;
    public final RecipeFunction stonecutting;
    public final RecipeFunction smithing;

    public RecipesEventJS(Map<ResourceLocation, RecipeTypeJS> t) {
        ConsoleJS.SERVER.info("Scanning recipes...");
        this.addedRecipes = new ArrayList<RecipeJS>();
        this.removedRecipes = new HashSet<RecipeJS>();
        this.modifiedRecipes = new HashSet<RecipeJS>();
        this.recipeFunctions = new HashMap<String, Object>();
        HashMap<String, Map> serializers = new HashMap<String, Map>();
        for (Map.Entry entry : KubeJSRegistries.recipeSerializers().entrySet()) {
            serializers.computeIfAbsent(((ResourceKey)entry.getKey()).m_135782_().m_135827_(), n -> new HashMap()).put(((ResourceKey)entry.getKey()).m_135782_().m_135815_(), (RecipeSerializer)entry.getValue());
        }
        for (Map.Entry entry : serializers.entrySet()) {
            HashMap<String, RecipeFunction> funcs = new HashMap<String, RecipeFunction>();
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                ResourceLocation location;
                RecipeTypeJS typeJS = t.get(location = new ResourceLocation((String)entry.getKey(), (String)entry1.getKey()));
                RecipeFunction func = new RecipeFunction(this, location, typeJS != null ? typeJS : new JsonRecipeTypeJS((RecipeSerializer)entry1.getValue()));
                funcs.put(UtilsJS.convertSnakeCaseToCamelCase((String)entry1.getKey()), func);
                funcs.put((String)entry1.getKey(), func);
                this.recipeFunctions.put(UtilsJS.convertSnakeCaseToCamelCase((String)entry.getKey() + "_" + (String)entry1.getKey()), func);
                this.recipeFunctions.put((String)entry.getKey() + "_" + (String)entry1.getKey(), func);
            }
            this.recipeFunctions.put(UtilsJS.convertSnakeCaseToCamelCase((String)entry.getKey()), funcs);
            this.recipeFunctions.put((String)entry.getKey(), funcs);
        }
        SpecialRecipeSerializerManager.INSTANCE.reset();
        ServerEvents.SPECIAL_RECIPES.post(SpecialRecipeSerializerManager.INSTANCE);
        this.shaped = this.getRecipeFunction(CommonProperties.get().serverOnly ? "minecraft:crafting_shaped" : "kubejs:shaped");
        this.shapeless = this.getRecipeFunction(CommonProperties.get().serverOnly ? "minecraft:crafting_shapeless" : "kubejs:shapeless");
        this.smelting = this.getRecipeFunction("minecraft:smelting");
        this.blasting = this.getRecipeFunction("minecraft:blasting");
        this.smoking = this.getRecipeFunction("minecraft:smoking");
        this.campfireCooking = this.getRecipeFunction("minecraft:campfire_cooking");
        this.stonecutting = this.getRecipeFunction("minecraft:stonecutting");
        this.smithing = this.getRecipeFunction("minecraft:smithing");
    }

    @HideFromJS
    public void post(RecipeManager recipeManager, Map<ResourceLocation, JsonObject> jsonMap) {
        RecipeJS.itemErrors = false;
        TagContext.INSTANCE.setValue((Object)KubeJSReloadListener.resources.f_206849_.m_203904_().stream().filter(result -> result.f_203928_() == Registry.f_122904_).findFirst().map(result -> TagContext.usingResult((TagManager.LoadResult<Item>)((TagManager.LoadResult)UtilsJS.cast(result)))).orElseGet(() -> {
            ConsoleJS.SERVER.warn("Failed to load item tags during recipe event! Using replaceInput etc. will not work!");
            return TagContext.EMPTY;
        }));
        Stopwatch timer = Stopwatch.createStarted();
        JsonObject allRecipeMap = new JsonObject();
        for (Map.Entry<ResourceLocation, JsonObject> entry : jsonMap.entrySet()) {
            ResourceLocation recipeId = entry.getKey();
            if (Platform.isForge() && recipeId.m_135815_().startsWith("_")) continue;
            String recipeIdAndType = recipeId + "[unknown:type]";
            try {
                JsonObject json = entry.getValue();
                String type = GsonHelper.m_13906_((JsonObject)json, (String)"type");
                recipeIdAndType = recipeId + "[" + type + "]";
                if (!RecipePlatformHelper.get().processConditions(recipeManager, json, "conditions")) {
                    if (!DevProperties.get().logSkippedRecipes) continue;
                    ConsoleJS.SERVER.info("Skipping loading recipe " + recipeIdAndType + " as it's conditions were not met");
                    continue;
                }
                if (type.equals(FORGE_CONDITIONAL)) {
                    JsonArray items = GsonHelper.m_13933_((JsonObject)json, (String)"recipes");
                    boolean skip = true;
                    for (int idx = 0; idx < items.size(); ++idx) {
                        JsonElement e = items.get(idx);
                        if (!e.isJsonObject()) {
                            throw new RecipeExceptionJS("Invalid recipes entry at index " + idx + " Must be JsonObject");
                        }
                        JsonObject o = e.getAsJsonObject();
                        if (!RecipePlatformHelper.get().processConditions(recipeManager, o, "conditions")) continue;
                        json = o.get("recipe").getAsJsonObject();
                        type = GsonHelper.m_13906_((JsonObject)json, (String)"type");
                        recipeIdAndType = recipeId + "[" + type + "]";
                        skip = false;
                        break;
                    }
                    if (skip) {
                        if (!DevProperties.get().logSkippedRecipes) continue;
                        ConsoleJS.SERVER.info("Skipping loading recipe " + recipeIdAndType + " as it's conditions were not met");
                        continue;
                    }
                }
                RecipeFunction function = this.getRecipeFunction(type);
                if (function.type == null) {
                    throw new MissingRecipeFunctionException("Unknown recipe type!").fallback();
                }
                RecipeJS recipe2 = function.type.factory.get();
                recipe2.id = recipeId;
                recipe2.type = function.type;
                recipe2.json = json;
                recipe2.originalRecipe = RecipePlatformHelper.get().fromJson(recipe2);
                if (recipe2.originalRecipe == null) {
                    if (!DevProperties.get().logSkippedRecipes) continue;
                    ConsoleJS.SERVER.info("Skipping loading recipe " + recipeIdAndType + " as it's conditions were not met");
                    continue;
                }
                recipe2.deserializeJson();
                this.originalRecipes.add(recipe2);
                if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    if (SpecialRecipeSerializerManager.INSTANCE.isSpecial(recipe2.originalRecipe)) {
                        ConsoleJS.SERVER.debug("Loaded recipe " + recipeIdAndType + ": <dynamic>");
                    } else {
                        ConsoleJS.SERVER.debug("Loaded recipe " + recipeIdAndType + ": " + recipe2.getFromToString());
                    }
                }
                if (DataExport.dataExport == null) continue;
                allRecipeMap.add(recipe2.getId(), (JsonElement)json);
            }
            catch (Throwable ex) {
                block27: {
                    block26: {
                        if (!(ex instanceof RecipeExceptionJS)) break block26;
                        RecipeExceptionJS rex = (RecipeExceptionJS)ex;
                        if (!rex.fallback) break block27;
                    }
                    if (DevProperties.get().logErroringRecipes) {
                        ConsoleJS.SERVER.warn("Failed to parse recipe '" + recipeIdAndType + "'! Falling back to vanilla", ex, SKIP_ERROR);
                    }
                    try {
                        this.fallbackedRecipes.add(Objects.requireNonNull(RecipeManager.m_44045_((ResourceLocation)recipeId, (JsonObject)entry.getValue())));
                    }
                    catch (JsonParseException | IllegalArgumentException | NullPointerException ex2) {
                        if (!DevProperties.get().logErroringRecipes) continue;
                        ConsoleJS.SERVER.warn("Failed to parse recipe " + recipeIdAndType, ex2, SKIP_ERROR);
                    }
                    catch (Exception ex3) {
                        ConsoleJS.SERVER.warn("Failed to parse recipe " + recipeIdAndType + ":");
                        ConsoleJS.SERVER.printStackTrace(false, ex3, SKIP_ERROR);
                    }
                    continue;
                }
                if (!DevProperties.get().logErroringRecipes) continue;
                ConsoleJS.SERVER.warn("Failed to parse recipe '" + recipeIdAndType + "'", ex, SKIP_ERROR);
            }
        }
        MutableInt removed = new MutableInt(0);
        MutableInt added = new MutableInt(0);
        MutableInt failed = new MutableInt(0);
        MutableInt fallbacked = new MutableInt(0);
        this.modifiedRecipesCount = new AtomicInteger(0);
        ConsoleJS.SERVER.info("Found " + this.originalRecipes.size() + " recipes and " + this.fallbackedRecipes.size() + " failed recipes in " + timer.stop());
        timer.reset().start();
        ServerEvents.RECIPES.post(this);
        ConsoleJS.SERVER.info("Posted recipe events in " + timer.stop());
        HashMap recipesByName = new HashMap();
        timer.reset().start();
        this.originalRecipes.stream().filter(recipe -> {
            if (this.removedRecipes.contains(recipe)) {
                removed.increment();
                return false;
            }
            return true;
        }).map(recipe -> {
            try {
                recipe.originalRecipe = recipe.createRecipe();
            }
            catch (Throwable ex) {
                ConsoleJS.SERVER.warn("Error parsing recipe " + recipe + ": " + recipe.json, ex);
                failed.increment();
            }
            return recipe.originalRecipe;
        }).filter(Objects::nonNull).forEach(recipe -> {
            ResourceLocation id = recipe.m_6423_();
            ResourceLocation ser = KubeJSRegistries.recipeSerializers().getId((Object)recipe.m_7707_());
            Recipe oldEntry = recipesByName.put(id, recipe);
            if (oldEntry != null) {
                ResourceLocation oldSer = KubeJSRegistries.recipeSerializers().getId((Object)oldEntry.m_7707_());
                if (DevProperties.get().logOverrides) {
                    ConsoleJS.SERVER.info("Overriding existing recipe with ID " + recipe.m_6423_() + "[" + oldSer + " => " + ser + "] during phase PARSE!");
                }
            }
        });
        this.fallbackedRecipes.stream().filter(Objects::nonNull).forEach(recipe -> {
            ResourceLocation id = recipe.m_6423_();
            ResourceLocation ser = KubeJSRegistries.recipeSerializers().getId((Object)recipe.m_7707_());
            Recipe oldEntry = recipesByName.put(id, recipe);
            if (oldEntry != null) {
                ResourceLocation oldSer = KubeJSRegistries.recipeSerializers().getId((Object)oldEntry.m_7707_());
                if (DevProperties.get().logOverrides) {
                    ConsoleJS.SERVER.info("Overriding existing recipe with ID " + recipe.m_6423_() + "[" + oldSer + " => " + ser + "] during phase FALLBACK!");
                }
            }
        });
        ConsoleJS.SERVER.info("Modified & removed recipes in " + timer.stop());
        timer.reset().start();
        this.addedRecipes.stream().map(recipe -> {
            try {
                recipe.originalRecipe = recipe.createRecipe();
            }
            catch (Throwable ex) {
                ConsoleJS.SERVER.warn("Error creating recipe " + recipe + ": " + recipe.json, ex, SKIP_ERROR);
                failed.increment();
            }
            return recipe.originalRecipe;
        }).filter(Objects::nonNull).forEach(recipe -> {
            added.increment();
            ResourceLocation id = recipe.m_6423_();
            ResourceLocation ser = KubeJSRegistries.recipeSerializers().getId((Object)recipe.m_7707_());
            Recipe oldEntry = recipesByName.put(id, recipe);
            if (oldEntry != null) {
                ResourceLocation oldSer = KubeJSRegistries.recipeSerializers().getId((Object)oldEntry.m_7707_());
                if (DevProperties.get().logOverrides) {
                    ConsoleJS.SERVER.info("Overriding existing recipe with ID " + recipe.m_6423_() + "[" + oldSer + " => " + ser + "] during phase ADD!");
                }
                removed.increment();
            }
        });
        if (DataExport.dataExport != null) {
            for (RecipeJS r : this.removedRecipes) {
                JsonElement jsonElement = allRecipeMap.get(r.getId());
                if (!(jsonElement instanceof JsonObject)) continue;
                JsonObject json = (JsonObject)jsonElement;
                json.addProperty("removed", Boolean.valueOf(true));
            }
            DataExport.dataExport.add("recipes", (JsonElement)allRecipeMap);
        }
        ConsoleJS.SERVER.info("Added recipes in " + timer.stop());
        HashMap newRecipeMap = (HashMap)Util.m_137469_(new HashMap(), map -> recipesByName.forEach((id, recipe) -> {
            RecipeType type = recipe.m_6671_();
            Map recipes = map.computeIfAbsent(type, t -> new HashMap());
            recipes.put(id, recipe);
        }));
        RecipePlatformHelper.get().pingNewRecipes(newRecipeMap);
        recipeManager.f_199900_ = recipesByName;
        recipeManager.f_44007_ = newRecipeMap;
        ConsoleJS.SERVER.info("Added " + added.getValue() + " recipes, removed " + removed.getValue() + " recipes, modified " + this.modifiedRecipesCount.get() + " recipes, with " + failed.getValue() + " failed recipes and " + fallbacked.getValue() + " fall-backed recipes");
        RecipeJS.itemErrors = false;
        if (CommonProperties.get().debugInfo) {
            ConsoleJS.SERVER.info("======== Debug output of all added recipes ========");
            for (RecipeJS r : this.addedRecipes) {
                ConsoleJS.SERVER.info(r.id + ": " + r.json);
            }
            ConsoleJS.SERVER.info("======== Debug output of all modified recipes ========");
            for (RecipeJS r : this.modifiedRecipes) {
                ConsoleJS.SERVER.info(r.id + ": " + r.json + " FROM " + r.originalJson);
            }
            ConsoleJS.SERVER.info("======== Debug output of all removed recipes ========");
            for (RecipeJS r : this.removedRecipes) {
                ConsoleJS.SERVER.info(r.id + ": " + r.json);
            }
        }
    }

    public Map<String, Object> getRecipes() {
        return this.recipeFunctions;
    }

    public RecipeJS addRecipe(RecipeJS r, RecipeTypeJS type, RecipeArguments args) {
        this.addedRecipes.add(r);
        if (DevProperties.get().logAddedRecipes) {
            ConsoleJS.SERVER.info("+ " + r.getType() + ": " + r.getFromToString());
        } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
            ConsoleJS.SERVER.debug("+ " + r.getType() + ": " + r.getFromToString());
        }
        return r;
    }

    public RecipeFilter customFilter(RecipeFilter filter) {
        return filter;
    }

    public void forEachRecipe(RecipeFilter filter, Consumer<RecipeJS> consumer) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            this.originalRecipes.forEach(consumer);
        } else if (filter != RecipeFilter.ALWAYS_FALSE) {
            this.originalRecipes.stream().filter(filter).forEach(consumer);
        }
    }

    public void forEachRecipeAsync(RecipeFilter filter, Consumer<RecipeJS> consumer) {
        this.forEachRecipe(filter, consumer);
    }

    public int countRecipes(RecipeFilter filter) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            return this.originalRecipes.size();
        }
        if (filter != RecipeFilter.ALWAYS_FALSE) {
            return (int)this.originalRecipes.stream().filter(filter).count();
        }
        return 0;
    }

    public boolean containsRecipe(RecipeFilter filter) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            return true;
        }
        if (filter != RecipeFilter.ALWAYS_FALSE) {
            return this.originalRecipes.stream().anyMatch(filter);
        }
        return false;
    }

    public int remove(RecipeFilter filter) {
        MutableInt count = new MutableInt();
        this.forEachRecipeAsync(filter, r -> {
            if (this.removedRecipes.add((RecipeJS)r)) {
                if (DevProperties.get().logRemovedRecipes) {
                    ConsoleJS.SERVER.info("- " + r + ": " + r.getFromToString());
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("- " + r + ": " + r.getFromToString());
                }
                count.increment();
            }
        });
        return count.getValue();
    }

    public int replaceInput(RecipeFilter filter, IngredientMatch match, Ingredient with, ItemInputTransformer transformer) {
        AtomicInteger count = new AtomicInteger();
        String is = match.toString();
        String ws = with.toString();
        this.forEachRecipeAsync(filter, r -> {
            if (r.replaceInput(match, with, transformer)) {
                r.serializeInputs = true;
                r.save();
                count.incrementAndGet();
                this.modifiedRecipes.add((RecipeJS)r);
                if (DevProperties.get().logModifiedRecipes) {
                    ConsoleJS.SERVER.info("~ " + r + ": IN " + is + " -> " + ws);
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("~ " + r + ": IN " + is + " -> " + ws);
                }
            }
        });
        this.modifiedRecipesCount.addAndGet(count.get());
        return count.get();
    }

    public int replaceInput(RecipeFilter filter, IngredientMatch match, Ingredient with) {
        return this.replaceInput(filter, match, with, ItemInputTransformer.DEFAULT);
    }

    public int replaceOutput(RecipeFilter filter, IngredientMatch match, ItemStack with, ItemOutputTransformer transformer) {
        AtomicInteger count = new AtomicInteger();
        String is = match.ingredient.toString();
        String ws = with.kjs$toItemString();
        this.forEachRecipeAsync(filter, r -> {
            if (r.replaceOutput(match, with, transformer)) {
                r.serializeOutputs = true;
                r.save();
                count.incrementAndGet();
                this.modifiedRecipes.add((RecipeJS)r);
                if (DevProperties.get().logModifiedRecipes) {
                    ConsoleJS.SERVER.info("~ " + r + ": OUT " + is + " -> " + ws);
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("~ " + r + ": OUT " + is + " -> " + ws);
                }
            }
        });
        this.modifiedRecipesCount.addAndGet(count.get());
        return count.get();
    }

    public int replaceOutput(RecipeFilter filter, IngredientMatch match, ItemStack with) {
        return this.replaceOutput(filter, match, with, ItemOutputTransformer.DEFAULT);
    }

    public RecipeFunction getRecipeFunction(@Nullable String id) {
        if (id == null || id.isEmpty()) {
            throw new NullPointerException("Recipe type is null!");
        }
        String namespace = UtilsJS.getNamespace(id);
        String path = UtilsJS.getPath(id);
        Object func0 = this.recipeFunctions.get(namespace);
        if (func0 instanceof RecipeFunction) {
            RecipeFunction fn = (RecipeFunction)func0;
            return fn;
        }
        if (!(func0 instanceof Map)) {
            throw new NullPointerException("Unknown recipe type: " + id);
        }
        RecipeFunction func = (RecipeFunction)((Map)func0).get(path);
        if (func == null) {
            throw new NullPointerException("Unknown recipe type: " + id);
        }
        return func;
    }

    public RecipeJS custom(JsonObject json) {
        if (json == null || !json.has("type")) {
            throw new RecipeExceptionJS("JSON does not contain 'type' key!");
        }
        return this.getRecipeFunction(json.get("type").getAsString()).createRecipe(new Object[]{json});
    }

    public void printTypes() {
        ConsoleJS.SERVER.info("== All recipe types [used] ==");
        HashSet list = new HashSet();
        this.originalRecipes.forEach(r -> list.add(r.type.toString()));
        list.stream().sorted().forEach(ConsoleJS.SERVER::info);
        ConsoleJS.SERVER.info(list.size() + " types");
    }

    public void printAllTypes() {
        ConsoleJS.SERVER.info("== All recipe types [available] ==");
        List<String> list = KubeJSRegistries.recipeSerializers().entrySet().stream().map(e -> ((ResourceKey)e.getKey()).m_135782_().toString()).sorted().toList();
        list.forEach(ConsoleJS.SERVER::info);
        ConsoleJS.SERVER.info(list.size() + " types");
    }

    public void printExamples(String type) {
        List list = this.originalRecipes.stream().filter(recipeJS -> recipeJS.type.toString().equals(type)).collect(Collectors.toList());
        Collections.shuffle(list);
        ConsoleJS.SERVER.info("== Random examples of '" + type + "' ==");
        for (int i = 0; i < Math.min(list.size(), 5); ++i) {
            RecipeJS r = (RecipeJS)list.get(i);
            ConsoleJS.SERVER.info("- " + r.getOrCreateId() + ":\n" + JsonIO.toPrettyString((JsonElement)r.json));
        }
    }

    public void setItemErrors(boolean b) {
        RecipeJS.itemErrors = b;
    }

    public void stage(RecipeFilter filter, String stage) {
        this.forEachRecipe(filter, r -> r.stage(stage));
    }
}

