/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_forge.util;

import com.natamus.collective_common_forge.functions.DataFunctions;
import com.natamus.collective_common_forge.functions.ItemFunctions;
import com.natamus.collective_common_forge.functions.NumberFunctions;
import com.natamus.collective_common_forge.functions.PlayerFunctions;
import com.natamus.starterkit_common_forge.config.ConfigHandler;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class Util {
    public static String startergearstring = "";
    private static final String dirpath = DataFunctions.getConfigDirectory() + File.separator + "starterkit";

    public static void getOrCreateGearConfig(boolean first) throws IOException {
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "starterkit.txt");
        if (dir.isDirectory() && file.isFile()) {
            String configstring = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "starterkit.txt", new String[0])), StandardCharsets.UTF_8);
            if (configstring.startsWith("'")) {
                startergearstring = configstring;
            } else {
                HashMap<String, ItemStack> simplegear = new HashMap<String, ItemStack>();
                for (String line : configstring.split(",")) {
                    Item item;
                    String[] itemspl;
                    String[] linespl = line.replace(" ", "").trim().split(":\"");
                    if (linespl.length < 2) continue;
                    int amount = 1;
                    String slotstring = linespl[0].replace("\"", "").trim();
                    String itemstring = linespl[1].replace("\"", "").trim();
                    if (itemstring.contains("-") && (itemspl = itemstring.split("-")).length > 1) {
                        itemstring = itemspl[0];
                        if (NumberFunctions.isNumeric((String)itemspl[1])) {
                            amount = Integer.parseInt(itemspl[1]);
                        }
                    }
                    ResourceLocation itemloc = new ResourceLocation(itemstring);
                    if (Registry.f_122827_.m_6566_().contains(itemloc)) {
                        item = (Item)Registry.f_122827_.m_7745_(itemloc);
                    } else {
                        if (!Registry.f_122824_.m_6566_().contains(itemloc)) continue;
                        Block block = (Block)Registry.f_122824_.m_7745_(itemloc);
                        item = block.m_5456_();
                    }
                    simplegear.put(slotstring, new ItemStack((ItemLike)item, amount));
                }
                startergearstring = PlayerFunctions.getPlayerGearStringFromHashMap(simplegear);
            }
        } else {
            dir.mkdirs();
            PrintWriter writer = new PrintWriter(dirpath + File.separator + "starterkit.txt", StandardCharsets.UTF_8);
            writer.println("'offhand' : '{Count:1b,id:\"minecraft:shield\",tag:{Damage:0}}',");
            writer.println("'head' : '',");
            writer.println("'chest' : '',");
            writer.println("'legs' : '',");
            writer.println("'feet' : '{Count:1b,id:\"minecraft:leather_boots\",tag:{Damage:0}}',");
            NonNullList emptyinventory = NonNullList.m_122780_((int)36, (Object)ItemStack.f_41583_);
            for (int i = 0; i < emptyinventory.size(); ++i) {
                String itemstring = "";
                if (i == 0) {
                    itemstring = "{Count:1b,id:\"minecraft:wooden_sword\",tag:{Damage:0}}";
                } else if (i == 1) {
                    itemstring = "{Count:9b,id:\"minecraft:bread\"}";
                }
                writer.println(i + " : '" + itemstring + "',");
            }
            writer.close();
            if (first) {
                Util.getOrCreateGearConfig(false);
            }
        }
    }

    public static boolean createGearConfigFromGearString(String gearstring) throws IOException {
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "starterkit.txt");
        if (dir.isDirectory() && file.isFile()) {
            File renamedfile = new File(dirpath + File.separator + "starterkit-old.txt");
            int r = 0;
            while (renamedfile.exists()) {
                renamedfile = new File(dirpath + File.separator + "starterkit-old_" + r + ".txt");
                ++r;
            }
            file.renameTo(renamedfile);
        } else {
            dir.mkdirs();
        }
        PrintWriter writer = new PrintWriter(dirpath + File.separator + "starterkit.txt", StandardCharsets.UTF_8);
        writer.println(gearstring);
        writer.close();
        Util.getOrCreateGearConfig(false);
        return true;
    }

    public static void setStarterKit(Player player) {
        if (startergearstring.equals("")) {
            return;
        }
        ArrayList<ItemStack> toAddAfter = new ArrayList<ItemStack>();
        if (ConfigHandler.addExistingItemsAfterKitSet) {
            Inventory inv = player.m_150109_();
            boolean isempty = true;
            for (int i = 0; i < 36; ++i) {
                ItemStack itemStack = inv.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                toAddAfter.add(itemStack.m_41777_());
            }
        }
        PlayerFunctions.setPlayerGearFromString((Player)player, (String)startergearstring);
        if (toAddAfter.size() > 0) {
            for (ItemStack itemStackToAdd : toAddAfter) {
                ItemFunctions.giveOrDropItemStack((Player)player, (ItemStack)itemStackToAdd);
            }
        }
    }

    public static boolean processNewGearString(String gearstring) {
        try {
            if (Util.createGearConfigFromGearString(gearstring)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

