/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.material.Material;
import net.silentchaos512.gems.GemsBase;
import net.silentchaos512.gems.block.GemBlock;
import net.silentchaos512.gems.block.GemGlassBlock;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.block.GemOreBlock;
import net.silentchaos512.gems.block.GlowroseBlock;
import net.silentchaos512.gems.block.PottedGlowroseBlock;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.data.GemsWorldGen;
import net.silentchaos512.gems.item.GemBlockItem;
import net.silentchaos512.gems.item.GemItem;
import net.silentchaos512.gems.setup.Registration;
import net.silentchaos512.gems.world.OreConfigDefaults;
import net.silentchaos512.lib.registry.BlockRegistryObject;
import net.silentchaos512.lib.registry.ItemRegistryObject;
import net.silentchaos512.utils.Color;

public enum Gems {
    RUBY(15080733, Rarity.COMMON, OreConfigDefaults.defaults(4, 8, 2, -64, 32, 0.2f), OreConfigDefaults.empty(), OreConfigDefaults.empty()),
    CARNELIAN(14699805, Rarity.UNCOMMON, OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 8, 1, 25, 110), OreConfigDefaults.empty()),
    TOPAZ(15102237, Rarity.COMMON, OreConfigDefaults.defaults(4, 8, 2, -56, 40, 0.2f), OreConfigDefaults.empty(), OreConfigDefaults.empty()),
    CITRINE(13077251, Rarity.UNCOMMON, OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 8, 1, 25, 110), OreConfigDefaults.empty()),
    HELIODOR(15123741, Rarity.COMMON, OreConfigDefaults.defaults(1, 6, 4, -80, -32, 0.8f), OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 9, 1, 16, 72)),
    MOLDAVITE(10934563, Rarity.UNCOMMON, OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 8, 1, 25, 110), OreConfigDefaults.empty()),
    PERIDOT(2743064, Rarity.COMMON, OreConfigDefaults.defaults(4, 8, 2, -56, 40, 0.2f), OreConfigDefaults.empty(), OreConfigDefaults.empty()),
    TURQUOISE(4060349, Rarity.RARE, OreConfigDefaults.defaults(1, 6, 4, -80, -32, 0.8f), OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 9, 1, 16, 72)),
    KYANITE(4310259, Rarity.RARE, OreConfigDefaults.empty(), OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 9, 1, 16, 72)),
    SAPPHIRE(1925349, Rarity.COMMON, OreConfigDefaults.defaults(4, 8, 2, -80, 32, 0.2f), OreConfigDefaults.empty(), OreConfigDefaults.empty()),
    IOLITE(7685109, Rarity.UNCOMMON, OreConfigDefaults.defaults(1, 6, 4, -80, -32, 0.8f), OreConfigDefaults.defaults(2, 8, 1, 20, 80), OreConfigDefaults.empty()),
    ALEXANDRITE(11220965, Rarity.UNCOMMON, OreConfigDefaults.defaults(1, 6, 4, -80, -32, 0.8f), OreConfigDefaults.defaults(2, 8, 1, 20, 80), OreConfigDefaults.empty()),
    AMMOLITE(14363647, Rarity.RARE, OreConfigDefaults.empty(), OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 9, 1, 16, 72)),
    ROSE_QUARTZ(16731819, Rarity.RARE, OreConfigDefaults.empty(), OreConfigDefaults.empty(), OreConfigDefaults.defaults(2, 9, 1, 16, 72)),
    BLACK_DIAMOND(6246988, Rarity.EPIC, OreConfigDefaults.empty(), OreConfigDefaults.defaults(3, 8, 3, -10, 60), OreConfigDefaults.empty()),
    WHITE_DIAMOND(14008786, Rarity.EPIC, OreConfigDefaults.empty(), OreConfigDefaults.empty(), OreConfigDefaults.defaults(3, 8, 3, -10, 60));

    private final Color color;
    private final Rarity rarity;
    private final Map<ResourceKey<Level>, OreConfigDefaults> oreConfigDefaults = new HashMap<ResourceKey<Level>, OreConfigDefaults>();
    BlockRegistryObject<GemOreBlock> ore;
    BlockRegistryObject<GemOreBlock> deepslateOre;
    BlockRegistryObject<GemOreBlock> netherOre;
    BlockRegistryObject<GemOreBlock> endOre;
    BlockRegistryObject<GemBlock> block;
    BlockRegistryObject<GemBlock> bricks;
    BlockRegistryObject<GemGlassBlock> glass;
    BlockRegistryObject<GlowroseBlock> glowrose;
    BlockRegistryObject<FlowerPotBlock> pottedGlowrose;
    Map<GemLampBlock.State, BlockRegistryObject<GemLampBlock>> lamps = new EnumMap<GemLampBlock.State, BlockRegistryObject<GemLampBlock>>(GemLampBlock.State.class);
    ItemRegistryObject<GemItem> item;
    ItemRegistryObject<GemItem> shard;
    final TagKey<Block> blockTag;
    final TagKey<Block> glowroseTag;
    final TagKey<Block> oreTag;
    final TagKey<Block> modOresTag;
    final TagKey<Item> blockItemTag;
    final TagKey<Item> glowroseItemTag;
    final TagKey<Item> oreItemTag;
    final TagKey<Item> modOresItemTag;
    final TagKey<Item> itemTag;

    private Gems(int colorIn, Rarity rarity, OreConfigDefaults overworldOres, OreConfigDefaults netherOres, OreConfigDefaults endOres) {
        this.color = new Color(colorIn);
        this.rarity = rarity;
        this.oreConfigDefaults.put((ResourceKey<Level>)Level.f_46428_, overworldOres);
        this.oreConfigDefaults.put((ResourceKey<Level>)Level.f_46429_, netherOres);
        this.oreConfigDefaults.put((ResourceKey<Level>)Level.f_46430_, endOres);
        String name = this.getName();
        this.blockTag = Gems.makeBlockTag(Gems.forgeId("storage_blocks/" + name));
        this.glowroseTag = Gems.makeBlockTag(GemsBase.getId("glowroses/" + this.getName()));
        this.oreTag = Gems.makeBlockTag(Gems.forgeId("ores/" + name));
        this.modOresTag = Gems.makeBlockTag(GemsBase.getId("ores/" + name));
        this.blockItemTag = Gems.makeItemTag(Gems.forgeId("storage_blocks/" + name));
        this.glowroseItemTag = Gems.makeItemTag(GemsBase.getId("glowroses/" + this.getName()));
        this.oreItemTag = Gems.makeItemTag(Gems.forgeId("ores/" + name));
        this.modOresItemTag = Gems.makeItemTag(GemsBase.getId("ores/" + name));
        this.itemTag = Gems.makeItemTag(Gems.forgeId("gems/" + name));
    }

    private static TagKey<Block> makeBlockTag(ResourceLocation name) {
        return BlockTags.create((ResourceLocation)name);
    }

    private static TagKey<Item> makeItemTag(ResourceLocation name) {
        return ItemTags.create((ResourceLocation)name);
    }

    private static ResourceLocation forgeId(String path) {
        return new ResourceLocation("forge", path);
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public int getColor() {
        return this.color.getColor();
    }

    public float[] getColorArray() {
        return new float[]{this.color.getRed(), this.color.getGreen(), this.color.getBlue()};
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)("gem.silentgems." + this.getName()));
    }

    public OreConfigDefaults getOreConfigDefaults(ResourceKey<Level> level) {
        return this.oreConfigDefaults.getOrDefault(level, this.oreConfigDefaults.get(Level.f_46428_));
    }

    public ConfiguredFeature<OreConfiguration, ?> createOreConfiguredFeature(ResourceKey<Level> level) {
        OreConfiguration oreConfiguration;
        OreConfigDefaults config = this.getOreConfigDefaults(level);
        if (level == Level.f_46429_) {
            oreConfiguration = new OreConfiguration(OreFeatures.f_195074_, ((GemOreBlock)this.netherOre.get()).m_49966_(), config.size(), config.discardChanceOnAirExposure());
            String configName = this.getName() + "_nether_ore";
        } else if (level == Level.f_46430_) {
            oreConfiguration = new OreConfiguration(GemsWorldGen.BASE_STONE_END, ((GemOreBlock)this.endOre.get()).m_49966_(), config.size(), config.discardChanceOnAirExposure());
            String configName = this.getName() + "_end_ore";
        } else {
            ImmutableList targetList = ImmutableList.of((Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195072_, (BlockState)((GemOreBlock)this.ore.get()).m_49966_()), (Object)OreConfiguration.m_161021_((RuleTest)OreFeatures.f_195073_, (BlockState)((GemOreBlock)this.deepslateOre.get()).m_49966_()));
            oreConfiguration = new OreConfiguration((List)targetList, config.size(), config.discardChanceOnAirExposure());
            String configName = this.getName() + "_ore";
        }
        return new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)oreConfiguration);
    }

    public PlacedFeature createOrePlacedFeature(ResourceKey<Level> level, Holder<ConfiguredFeature<?, ?>> configuredFeature) {
        OreConfigDefaults config = this.getOreConfigDefaults(level);
        if (level == Level.f_46429_) {
            String configName = this.getName() + "_nether_ore";
        } else if (level == Level.f_46430_) {
            String configName = this.getName() + "_end_ore";
        } else {
            String configName = this.getName() + "_ore";
        }
        return new PlacedFeature(configuredFeature, List.of(CountPlacement.m_191628_((int)config.count()), RarityFilter.m_191900_((int)config.rarity()), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)config.minHeight()), (VerticalAnchor)VerticalAnchor.m_158922_((int)config.maxHeight())), BiomeFilter.m_191561_()));
    }

    public ConfiguredFeature<RandomPatchConfiguration, ?> createGlowroseConfiguredFeature(ResourceKey<Level> level) {
        int baseSpread;
        OreConfigDefaults config = this.getOreConfigDefaults(level);
        int n = baseSpread = config.isEnabled() ? 2 : 0;
        if (level == Level.f_46429_) {
            String configName = this.getName() + "_nether_glowrose";
        } else if (level == Level.f_46430_) {
            String configName = this.getName() + "_end_glowrose";
        } else {
            String configName = this.getName() + "_glowrose";
        }
        RandomPatchConfiguration featureConfig = FeatureUtils.m_206480_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)this.getGlowrose())), List.of(), (int)32);
        return new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)featureConfig);
    }

    public PlacedFeature createGlowrosePlacedFeature(ResourceKey<Level> level, Holder<ConfiguredFeature<?, ?>> configuredFeature) {
        OreConfigDefaults config = this.getOreConfigDefaults(level);
        if (level == Level.f_46429_) {
            String configName = this.getName() + "_nether_glowrose";
        } else if (level == Level.f_46430_) {
            String configName = this.getName() + "_end_glowrose";
        } else {
            String configName = this.getName() + "_glowrose";
        }
        return new PlacedFeature(configuredFeature, List.of(RarityFilter.m_191900_((int)(128 * config.rarity())), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
    }

    public GemOreBlock getOre() {
        return (GemOreBlock)this.ore.get();
    }

    public GemOreBlock getDeepslateOre() {
        return (GemOreBlock)this.deepslateOre.get();
    }

    public GemOreBlock getNetherOre() {
        return (GemOreBlock)this.netherOre.get();
    }

    public GemOreBlock getEndOre() {
        return (GemOreBlock)this.endOre.get();
    }

    public GemBlock getBlock() {
        return (GemBlock)this.block.get();
    }

    public GemBlock getBricks() {
        return (GemBlock)this.bricks.get();
    }

    public GemGlassBlock getGlass() {
        return (GemGlassBlock)this.glass.get();
    }

    public GemLampBlock getLamp(GemLampBlock.State state) {
        return (GemLampBlock)this.lamps.get((Object)state).get();
    }

    public GlowroseBlock getGlowrose() {
        return (GlowroseBlock)this.glowrose.get();
    }

    public FlowerPotBlock getPottedGlowrose() {
        return (FlowerPotBlock)this.pottedGlowrose.get();
    }

    public GemItem getItem() {
        return (GemItem)this.item.get();
    }

    @Deprecated
    public GemItem getShard() {
        return (GemItem)this.shard.get();
    }

    public TagKey<Block> getOreTag() {
        return this.oreTag;
    }

    public TagKey<Block> getModOresTag() {
        return this.modOresTag;
    }

    public TagKey<Block> getBlockTag() {
        return this.blockTag;
    }

    public TagKey<Block> getGlowroseTag() {
        return this.glowroseTag;
    }

    public TagKey<Item> getOreItemTag() {
        return this.oreItemTag;
    }

    public TagKey<Item> getModOresItemTag() {
        return this.modOresItemTag;
    }

    public TagKey<Item> getBlockItemTag() {
        return this.blockItemTag;
    }

    public TagKey<Item> getGlowroseItemTag() {
        return this.glowroseItemTag;
    }

    public TagKey<Item> getItemTag() {
        return this.itemTag;
    }

    public static void registerBlocks() {
        for (Gems gem : Gems.values()) {
            gem.ore = Gems.registerBlock(gem.getName() + "_ore", () -> new GemOreBlock(gem, 2, "gem_ore", BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(3.0f).m_60999_().m_60918_(SoundType.f_56742_)));
        }
        for (Gems gem : Gems.values()) {
            gem.deepslateOre = Gems.registerBlock("deepslate_" + gem.getName() + "_ore", () -> new GemOreBlock(gem, 2, "deepslate_gem_ore", BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)gem.ore.get())).m_60913_(4.5f, 3.0f).m_60918_(SoundType.f_154677_)));
        }
        for (Gems gem : Gems.values()) {
            gem.netherOre = Gems.registerBlock(gem.getName() + "_nether_ore", () -> new GemOreBlock(gem, 3, "gem_nether_ore", BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)gem.ore.get())).m_60978_(4.0f).m_60918_(SoundType.f_56723_)));
        }
        for (Gems gem : Gems.values()) {
            gem.endOre = Gems.registerBlock(gem.getName() + "_end_ore", () -> new GemOreBlock(gem, 4, "gem_end_ore", BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)gem.ore.get())).m_60978_(6.0f)));
        }
        for (Gems gem : Gems.values()) {
            gem.block = Gems.registerBlock(gem.getName() + "_block", () -> new GemBlock(gem, "gem_block", BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(4.0f, 30.0f).m_60918_(SoundType.f_56743_)));
        }
        for (Gems gem : Gems.values()) {
            gem.bricks = Gems.registerBlock(gem.getName() + "_bricks", () -> new GemBlock(gem, "gem_bricks", BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 8.0f)));
        }
        BlockBehaviour.StatePredicate isNotSolid = (state, world, pos) -> false;
        for (Gems gem : Gems.values()) {
            gem.glass = Gems.registerBlock(gem.getName() + "_glass", () -> new GemGlassBlock(gem, BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(1.0f, 5.0f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_((state, world, pos, entityType) -> false).m_60924_(isNotSolid).m_60960_(isNotSolid).m_60971_(isNotSolid)));
        }
        for (Gems gem : Gems.values()) {
            gem.lamps.put(GemLampBlock.State.OFF, Gems.registerLamp(gem, GemLampBlock.State.OFF));
        }
        for (Gems gem : Gems.values()) {
            gem.lamps.put(GemLampBlock.State.ON, Gems.registerLamp(gem, GemLampBlock.State.ON));
        }
        for (Gems gem : Gems.values()) {
            gem.lamps.put(GemLampBlock.State.INVERTED_ON, Gems.registerLamp(gem, GemLampBlock.State.INVERTED_ON));
        }
        for (Gems gem : Gems.values()) {
            gem.lamps.put(GemLampBlock.State.INVERTED_OFF, Gems.registerLamp(gem, GemLampBlock.State.INVERTED_OFF));
        }
        for (Gems gem : Gems.values()) {
            gem.glowrose = Gems.registerBlock(gem.getName() + "_glowrose", () -> new GlowroseBlock(gem, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60918_(SoundType.f_56740_).m_60953_(state -> GemsConfig.Common.isLoaded() ? (Integer)GemsConfig.Common.glowroseNormalLight.get() : 10).m_60978_(0.0f).m_60910_()));
        }
        for (Gems gem : Gems.values()) {
            gem.pottedGlowrose = Gems.registerBlockNoItem("potted_" + gem.getName() + "_glowrose", () -> new PottedGlowroseBlock(gem, (Supplier<GlowroseBlock>)gem.glowrose, BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60953_(state -> GemsConfig.Common.isLoaded() ? (Integer)GemsConfig.Common.glowrosePottedLight.get() : 15).m_60978_(0.0f)));
            ((FlowerPotBlock)Blocks.f_50276_).addPlant(GemsBase.getId(gem.getName() + "_glowrose"), gem.pottedGlowrose);
        }
    }

    public static void registerItems() {
        for (Gems gem : Gems.values()) {
            gem.item = Gems.registerItem(gem.getName(), () -> new GemItem(gem, "gem", new Item.Properties().m_41491_(GemsBase.ITEM_GROUP)));
        }
    }

    private static <T extends Block> BlockRegistryObject<T> registerBlockNoItem(String name, Supplier<T> block) {
        return new BlockRegistryObject(Registration.BLOCKS.register(name, block));
    }

    private static <T extends Block> BlockRegistryObject<T> registerBlock(String name, Supplier<T> block) {
        return Gems.registerBlock(name, block, Gems::defaultBlockItem);
    }

    private static <T extends Block> BlockRegistryObject<T> registerBlock(String name, Supplier<T> block, Function<BlockRegistryObject<T>, Supplier<BlockItem>> item) {
        BlockRegistryObject<T> ret = Gems.registerBlockNoItem(name, block);
        if (item != null) {
            Registration.ITEMS.register(name, item.apply(ret));
        }
        return ret;
    }

    private static BlockRegistryObject<GemLampBlock> registerLamp(Gems gem, GemLampBlock.State state) {
        String name = gem.getName() + "_lamp" + (state.inverted() ? "_inverted" : "") + (state.lit() ? "_on" : "");
        return Gems.registerBlock(name, () -> new GemLampBlock(gem, state, BlockBehaviour.Properties.m_60939_((Material)Material.f_76312_).m_60913_(0.3f, 15.0f).m_60953_(s -> state.lit() ? 15 : 0)), state.hasItem() ? Gems::defaultBlockItem : null);
    }

    private static <T extends Item> ItemRegistryObject<T> registerItem(String name, Supplier<T> item) {
        return new ItemRegistryObject(Registration.ITEMS.register(name, item));
    }

    private static Supplier<BlockItem> defaultBlockItem(BlockRegistryObject<?> block) {
        return () -> new GemBlockItem((Block)block.get(), new Item.Properties().m_41491_(GemsBase.ITEM_GROUP));
    }
}

