/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.soul;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.silentchaos512.gems.util.TextUtil;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.MathUtils;

public enum SoulElement {
    NONE(Builder.create(1, Color.WHITE)),
    FORK(Builder.create(13, Color.CRIMSON).modifier("melee_damage", 0.15f).modifier("armor", -0.15f)),
    QUIRK(Builder.create(12, Color.CORNFLOWERBLUE).modifier("magic_damage", 0.15f).modifier("harvest_speed", -0.15f)),
    EJECT(Builder.create(11, Color.MEDIUMSEAGREEN).modifier("ranged_speed", 0.15f).modifier("melee_damage", -0.15f)),
    RIBBON(Builder.create(10, Color.HOTPINK).modifier("repair_efficiency", 0.15f).modifier("durability", -0.1f).modifier("armor_durability", -0.1f)),
    SNACK(Builder.create(18, Color.GOLDENROD).modifier("durability", 0.1f).modifier("armor_durability", 0.1f).modifier("ranged_speed", -0.15f)),
    GLOOM(Builder.create(17, Color.BLUEVIOLET).modifier("magic_damage", 0.2f).modifier("melee_damage", -0.1f)),
    PEPPER(Builder.create(16, Color.ORANGERED).modifier("harvest_speed", 0.1f).modifier("ranged_speed", 0.1f).modifier("repair_efficiency", -0.1f)),
    JOY(Builder.create(15, Color.YELLOW).modifier("armor", 0.15f).modifier("magic_damage", -0.15f)),
    PLUG(Builder.create(5, Color.DARKSEAGREEN).modifier("harvest_speed", 0.15f).modifier("ranged_damage", -0.15f)),
    STUN(Builder.create(6, Color.STEELBLUE).modifier("melee_damage", 0.1f).modifier("ranged_damage", 0.1f).modifier("armor", -0.15f)),
    KING(Builder.create(7, Color.ROYALBLUE).modifier("harvest_speed", 0.1f).modifier("repair_efficiency", 0.1f).modifier("ranged_speed", -0.15f)),
    FLEET(Builder.create(8, Color.MEDIUMPURPLE).modifier("armor", 0.1f).modifier("repair_efficiency", 0.1f).modifier("harvest_speed", -0.15f));

    public final int weight;
    public final int color;
    private final Map<String, Float> modifiers;

    private SoulElement(Builder builder) {
        this.weight = builder.weight;
        this.color = builder.color;
        this.modifiers = builder.modifiers;
    }

    public float getStatModifier(String stat) {
        return this.modifiers.getOrDefault(stat, Float.valueOf(0.0f)).floatValue();
    }

    public Component getDisplayName() {
        String translationKey = "soul.silentgems.element." + this.name().toLowerCase(Locale.ROOT);
        return TextUtil.withColor(Component.m_237115_((String)translationKey), this.color);
    }

    public static SoulElement selectRandom(Random random) {
        return SoulElement.selectRandom(random, 0.0f);
    }

    public static SoulElement selectRandom(Random random, float chanceOfNone) {
        if (MathUtils.tryPercentage((Random)random, (double)chanceOfNone)) {
            return NONE;
        }
        return SoulElement.values()[MathUtils.nextIntInclusive((Random)random, (int)1, (int)(SoulElement.values().length - 1))];
    }

    public static SoulElement fromString(String str) {
        for (SoulElement element : SoulElement.values()) {
            if (!element.name().equalsIgnoreCase(str)) continue;
            return element;
        }
        return NONE;
    }

    public static SoulElement read(FriendlyByteBuf buffer) {
        return (SoulElement)buffer.m_130066_(SoulElement.class);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeByte(this.ordinal());
    }

    private static final class Builder {
        private static final String DURABILITY = "durability";
        private static final String ARMOR_DURABILITY = "armor_durability";
        private static final String REPAIR_EFFICIENCY = "repair_efficiency";
        private static final String HARVEST_SPEED = "harvest_speed";
        private static final String MELEE_DAMAGE = "melee_damage";
        private static final String MAGIC_DAMAGE = "magic_damage";
        private static final String RANGED_DAMAGE = "ranged_damage";
        private static final String RANGED_SPEED = "ranged_speed";
        private static final String ARMOR = "armor";
        final int weight;
        final int color;
        final Map<String, Float> modifiers = new LinkedHashMap<String, Float>();

        private Builder(int weight, int color) {
            this.weight = weight;
            this.color = color;
        }

        static Builder create(int weight, Color color) {
            return new Builder(weight, color.getColor());
        }

        Builder modifier(String stat, float value) {
            this.modifiers.put(stat, Float.valueOf(value));
            return this;
        }
    }
}

