/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.soul;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gems.GemsBase;
import net.silentchaos512.gems.item.SoulGemItem;
import net.silentchaos512.gems.network.SyncSoulsPacket;
import net.silentchaos512.gems.soul.SoulElement;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.lib.util.PlayerUtils;
import net.silentchaos512.utils.Color;

public final class Soul {
    public static final int MAX_VALUE = 1000;
    public static final int STANDARD_KILL_VALUE = 50;
    private static final Map<EntityType<?>, Soul> MAP = new HashMap();
    private static final Map<String, Soul> MAP_BY_ID = new HashMap<String, Soul>();
    private final ResourceLocation id;
    private final Tuple<SoulElement, SoulElement> elements;
    private final Tuple<Integer, Integer> colors;
    private final EntityType<?> entityType;

    private Soul(EntityType<?> entityType) {
        this.entityType = entityType;
        this.id = NameUtils.fromEntityType(entityType);
        GemsBase.LOGGER.debug("creating soul for {}", (Object)this.id);
        Random random = new Random(this.id.hashCode());
        SoulElement element1 = SoulElement.selectRandom(random);
        SoulElement element2 = SoulElement.selectRandom(random, 0.2f);
        this.elements = new Tuple((Object)element1, (Object)(element2 != element1 ? element2 : SoulElement.NONE));
        SpawnEggItem egg = Soul.getSpawnEggForType(entityType);
        if (egg != null) {
            this.colors = new Tuple((Object)egg.f_151200_, (Object)egg.f_151201_);
        } else {
            this.colors = new Tuple((Object)random.nextInt(0x1000000), (Object)random.nextInt(0x1000000));
            GemsBase.LOGGER.debug("No spawn egg for {}, setting colors to {} and {}", (Object)this.id, (Object)Color.format((int)((Integer)this.colors.m_14418_())), (Object)Color.format((int)((Integer)this.colors.m_14419_())));
        }
    }

    @Nullable
    public static Soul from(LivingEntity entity) {
        return MAP.get(entity.m_6095_());
    }

    @Nullable
    public static Soul from(ResourceLocation id) {
        return Soul.from(id.toString());
    }

    @Nullable
    public static Soul from(String id) {
        return MAP_BY_ID.get(id);
    }

    public static Collection<Soul> getValues() {
        return MAP.values();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public SoulElement getPrimaryElement() {
        return (SoulElement)((Object)this.elements.m_14418_());
    }

    public SoulElement getSecondaryElement() {
        return (SoulElement)((Object)this.elements.m_14419_());
    }

    public int getPrimaryColor() {
        return (Integer)this.colors.m_14418_();
    }

    public int getSecondaryColor() {
        return (Integer)this.colors.m_14419_();
    }

    @Nullable
    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public int getKillValue(LivingEntity entity) {
        if (!entity.m_6072_()) {
            return 1000;
        }
        if (entity instanceof Slime) {
            Slime slimeEntity = (Slime)entity;
            int size = Mth.m_14045_((int)slimeEntity.m_33632_(), (int)1, (int)4);
            return 50 / (6 - size);
        }
        return 50;
    }

    public Component getEntityName() {
        return Component.m_237115_((String)("entity." + this.id.m_135827_() + "." + this.id.m_135815_()));
    }

    private Soul(FriendlyByteBuf buffer) {
        this.id = buffer.m_130281_();
        this.elements = new Tuple((Object)SoulElement.read(buffer), (Object)SoulElement.read(buffer));
        this.colors = new Tuple((Object)buffer.m_130242_(), (Object)buffer.m_130242_());
        this.entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.id);
    }

    public static Soul read(FriendlyByteBuf buffer) {
        return new Soul(buffer);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.id);
        ((SoulElement)((Object)this.elements.m_14418_())).write(buffer);
        ((SoulElement)((Object)this.elements.m_14419_())).write(buffer);
        buffer.m_130130_(((Integer)this.colors.m_14418_()).intValue());
        buffer.m_130130_(((Integer)this.colors.m_14419_()).intValue());
    }

    public static void handleSyncPacket(SyncSoulsPacket packet, Supplier<NetworkEvent.Context> context) {
        MAP.clear();
        MAP_BY_ID.clear();
        packet.getSouls().forEach(soul -> {
            MAP.put(soul.entityType, (Soul)soul);
            MAP_BY_ID.put(soul.id.toString(), (Soul)soul);
        });
        GemsBase.LOGGER.info("Received {} soul info objects from server", (Object)MAP.size());
        context.get().setPacketHandled(true);
    }

    @Nullable
    private static SpawnEggItem getSpawnEggForType(EntityType<?> entityType) {
        for (SpawnEggItem egg : SpawnEggItem.m_43233_()) {
            if (egg.m_43228_(null) != entityType) continue;
            return egg;
        }
        return null;
    }

    public static boolean canHaveSoulGem(EntityType<?> type) {
        return type.m_20674_() != MobCategory.MISC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Soul soul = (Soul)o;
        return this.id.equals((Object)soul.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Mod.EventBusSubscriber(modid="silentgems")
    public static final class Events {
        private Events() {
        }

        @SubscribeEvent
        public static void onServerAboutToStart(ServerStartingEvent event) {
            MAP.clear();
            for (EntityType entityType : ForgeRegistries.ENTITY_TYPES.getValues()) {
                if (!Soul.canHaveSoulGem(entityType)) continue;
                Soul soul = new Soul(entityType);
                MAP.put(entityType, soul);
                ResourceLocation id = NameUtils.fromEntityType((EntityType)entityType);
                MAP_BY_ID.put(id.toString(), soul);
            }
        }

        @SubscribeEvent
        public static void onMobKilled(LivingDeathEvent event) {
            Entity killer = event.getSource().m_7639_();
            if (killer instanceof Player) {
                Player player = (Player)killer;
                LivingEntity entity = event.getEntity();
                Soul soul = Soul.from(entity);
                if (soul != null) {
                    int killValue = soul.getKillValue(entity);
                    ItemStack partialGem = PlayerUtils.getFirstValidStack((Player)player, (boolean)true, (boolean)true, (boolean)false, stack -> stack.m_41720_() instanceof SoulGemItem && soul.equals(SoulGemItem.getSoul(stack)) && SoulGemItem.getSoulValue(stack) < 1000);
                    if (!partialGem.m_41619_()) {
                        SoulGemItem.addSoulValue(partialGem, killValue);
                        GemsBase.LOGGER.debug("Fill partial soul gem with {} x{}", (Object)soul.id, (Object)killValue);
                        return;
                    }
                    ItemStack emptyGem = PlayerUtils.getFirstValidStack((Player)player, (boolean)true, (boolean)true, (boolean)false, stack -> stack.m_41720_() instanceof SoulGemItem && SoulGemItem.getSoul(stack) == null);
                    if (!emptyGem.m_41619_()) {
                        SoulGemItem.setSoul(emptyGem, soul);
                        SoulGemItem.addSoulValue(emptyGem, killValue);
                        GemsBase.LOGGER.debug("Start filling empty soul gem with {} x{}", (Object)soul.id, (Object)killValue);
                    }
                }
            }
        }
    }
}

