/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.setup;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.setup.GemsContainers;
import net.silentchaos512.gems.setup.GemsItems;
import net.silentchaos512.gems.setup.GemsTraits;

public class Registration {
    public static final DeferredRegister<Block> BLOCKS = Registration.create(ForgeRegistries.BLOCKS);
    public static final DeferredRegister<MenuType<?>> CONTAINERS = Registration.create(ForgeRegistries.MENU_TYPES);
    public static final DeferredRegister<Item> ITEMS = Registration.create(ForgeRegistries.ITEMS);
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = Registration.create(ForgeRegistries.SOUND_EVENTS);

    private Registration() {
    }

    public static void register() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        CONTAINERS.register(modEventBus);
        ITEMS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        GemsBlocks.register();
        GemsContainers.register();
        GemsItems.register();
        if (ModList.get().isLoaded("silentgear")) {
            GemsTraits.registerSerializers();
        }
    }

    public static <T extends Block> Collection<T> getBlocks(Class<T> clazz) {
        return BLOCKS.getEntries().stream().map(RegistryObject::get).filter(clazz::isInstance).map(b -> b).collect(Collectors.toList());
    }

    public static <T extends Item> Collection<T> getItems(Class<T> clazz) {
        return ITEMS.getEntries().stream().map(RegistryObject::get).filter(clazz::isInstance).map(i -> i).collect(Collectors.toList());
    }

    public static Collection<Item> getItems(Predicate<Item> predicate) {
        return ITEMS.getEntries().stream().map(RegistryObject::get).filter(predicate).collect(Collectors.toList());
    }

    static <T> DeferredRegister<T> create(IForgeRegistry<T> registry) {
        return DeferredRegister.create(registry, (String)"silentgems");
    }
}

