/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.setup;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.silentchaos512.gems.GemsBase;
import net.silentchaos512.gems.block.OreBlockSG;
import net.silentchaos512.gems.setup.GemsItems;
import net.silentchaos512.gems.setup.Registration;
import net.silentchaos512.gems.util.Gems;
import net.silentchaos512.lib.registry.BlockRegistryObject;

public final class GemsBlocks {
    public static final BlockRegistryObject<Block> SILVER_ORE;
    public static final BlockRegistryObject<Block> DEEPSLATE_SILVER_ORE;
    public static final BlockRegistryObject<Block> SILVER_BLOCK;

    private GemsBlocks() {
    }

    static void register() {
    }

    @OnlyIn(value=Dist.CLIENT)
    static void registerRenderTypes(FMLClientSetupEvent event) {
        for (Gems gem : Gems.values()) {
            ItemBlockRenderTypes.setRenderLayer((Block)gem.getGlass(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)gem.getGlowrose(), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)gem.getPottedGlowrose(), (RenderType)RenderType.m_110463_());
        }
    }

    private static <T extends Block> BlockRegistryObject<T> registerNoItem(String name, Supplier<T> block) {
        return new BlockRegistryObject(Registration.BLOCKS.register(name, block));
    }

    private static <T extends Block> BlockRegistryObject<T> register(String name, Supplier<T> block) {
        return GemsBlocks.register(name, block, GemsBlocks::defaultItem);
    }

    private static <T extends Block> BlockRegistryObject<T> register(String name, Supplier<T> block, Function<BlockRegistryObject<T>, Supplier<? extends BlockItem>> item) {
        BlockRegistryObject<T> ret = GemsBlocks.registerNoItem(name, block);
        Registration.ITEMS.register(name, item.apply(ret));
        return ret;
    }

    private static <T extends Block> Supplier<BlockItem> defaultItem(BlockRegistryObject<T> block) {
        return () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(GemsBase.ITEM_GROUP));
    }

    private static OreBlockSG getSilverOre(BlockBehaviour.Properties properties) {
        return new OreBlockSG((ItemLike)GemsItems.RAW_SILVER, 2, properties){

            @Override
            public int getExpRandom(RandomSource random) {
                return 0;
            }
        };
    }

    static {
        Gems.registerBlocks();
        SILVER_ORE = GemsBlocks.register("silver_ore", () -> GemsBlocks.getSilverOre(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(3.0f)));
        DEEPSLATE_SILVER_ORE = GemsBlocks.register("deepslate_silver_ore", () -> GemsBlocks.getSilverOre(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)SILVER_ORE.get())).m_60913_(4.5f, 3.0f).m_60918_(SoundType.f_154677_)));
        SILVER_BLOCK = GemsBlocks.register("silver_block", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(4.0f, 30.0f).m_60918_(SoundType.f_56743_)));
    }
}

