/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.silentchaos512.gems.setup.GemsItems;
import net.silentchaos512.gems.soul.Soul;
import net.silentchaos512.gems.soul.SoulElement;
import net.silentchaos512.gems.util.TextUtil;

public class SoulGemItem
extends Item {
    private static final String NBT_SOUL = "Soul";
    private static final String NBT_VALUE = "SoulValue";

    public SoulGemItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getStack(Soul soul, int value) {
        ItemStack result = new ItemStack(GemsItems.SOUL_GEM);
        SoulGemItem.setSoul(result, soul);
        SoulGemItem.setSoulValue(result, value);
        return result;
    }

    public static ItemStack getStack(ResourceLocation soulId) {
        ItemStack result = new ItemStack(GemsItems.SOUL_GEM);
        result.m_41784_().m_128359_(NBT_SOUL, soulId.toString());
        return result;
    }

    private static String getSoulId(ItemStack stack) {
        return stack.m_41784_().m_128461_(NBT_SOUL);
    }

    @Nullable
    public static Soul getSoul(ItemStack stack) {
        return Soul.from(SoulGemItem.getSoulId(stack));
    }

    public static void setSoul(ItemStack stack, Soul soul) {
        if (!(stack.m_41720_() instanceof SoulGemItem)) {
            throw new IllegalArgumentException("Tried to set soul on item that is not a soul gem: " + stack);
        }
        stack.m_41784_().m_128359_(NBT_SOUL, soul.getId().toString());
    }

    public static int getSoulValue(ItemStack stack) {
        return stack.m_41784_().m_128451_(NBT_VALUE);
    }

    public static void setSoulValue(ItemStack stack, int value) {
        stack.m_41784_().m_128405_(NBT_VALUE, Mth.m_14045_((int)value, (int)0, (int)1000));
    }

    public static void addSoulValue(ItemStack stack, int value) {
        SoulGemItem.setSoulValue(stack, SoulGemItem.getSoulValue(stack) + value);
    }

    public static int getColor(ItemStack stack, int tintIndex) {
        Soul soul = SoulGemItem.getSoul(stack);
        if (soul == null) {
            return 0xFFFFFF;
        }
        if (tintIndex == 0) {
            return soul.getPrimaryColor();
        }
        if (tintIndex == 1) {
            return soul.getSecondaryColor();
        }
        return 0xFFFFFF;
    }

    public Component m_7626_(ItemStack stack) {
        Soul soul = SoulGemItem.getSoul(stack);
        if (soul != null) {
            Component entityName = soul.getEntityName();
            return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{entityName.m_6881_().m_130946_(" ")});
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Soul soul = SoulGemItem.getSoul(stack);
        if (soul != null) {
            int soulValue;
            if (flagIn.m_7050_()) {
                tooltip.add((Component)Component.m_237113_((String)("Soul ID: " + soul.getId())).m_130940_(ChatFormatting.DARK_GRAY));
            }
            tooltip.add(soul.getPrimaryElement().getDisplayName());
            SoulElement element2 = soul.getSecondaryElement();
            if (element2 != SoulElement.NONE) {
                tooltip.add(element2.getDisplayName());
            }
            MutableComponent valueText = (soulValue = SoulGemItem.getSoulValue(stack)) < 1000 ? Component.m_237113_((String)String.format("%d", soulValue)) : TextUtil.itemSub((ItemLike)this, "full", new Object[0]);
            tooltip.add((Component)TextUtil.itemSub((ItemLike)this, "value", valueText));
        }
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)new ItemStack((ItemLike)this));
            for (Soul soul : Soul.getValues()) {
                items.add((Object)SoulGemItem.getStack(soul, 1000));
            }
        }
    }

    public int m_142158_(ItemStack stack) {
        int value = SoulGemItem.getSoulValue(stack);
        return Math.round(13.0f - 13.0f * (float)value / 1000.0f);
    }

    public boolean m_142522_(ItemStack stack) {
        int value = SoulGemItem.getSoulValue(stack);
        return value > 0 && value < 1000;
    }
}

