/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.gear.trait;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gems.GemsBase;

public class CriticalStrikeTrait
extends SimpleTrait {
    public static final ITraitSerializer<CriticalStrikeTrait> SERIALIZER = new SimpleTrait.Serializer(GemsBase.getId("critical_strike"), CriticalStrikeTrait::new, (trait, json) -> {
        trait.damageMulti = GsonHelper.m_13915_((JsonObject)json, (String)"damage_multiplier");
        trait.activationChance = GsonHelper.m_13915_((JsonObject)json, (String)"activation_chance");
    }, (trait, buffer) -> {
        trait.damageMulti = buffer.readFloat();
        trait.activationChance = buffer.readFloat();
    }, (trait, buffer) -> {
        buffer.writeFloat(trait.damageMulti);
        buffer.writeFloat(trait.activationChance);
    });
    private float damageMulti;
    private float activationChance;

    public CriticalStrikeTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    public float onAttackEntity(TraitActionContext context, LivingEntity target, float baseValue) {
        if (GemsBase.RANDOM.nextFloat() < this.activationChance) {
            target.f_19853_.m_5594_(null, target.m_20183_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.5f);
            return baseValue * (1.0f + this.damageMulti) * (float)context.getTraitLevel();
        }
        return baseValue;
    }

    public Collection<String> getExtraWikiLines() {
        return Collections.singleton(String.format("Attacks deal %d%% more damage about %d%% of the time", (int)(100.0f * this.damageMulti), (int)(100.0f * this.activationChance)));
    }

    public static void serialize(JsonObject json, float damageMulti, float activationChance) {
        json.addProperty("damage_multiplier", (Number)Float.valueOf(damageMulti));
        json.addProperty("activation_chance", (Number)Float.valueOf(activationChance));
    }
}

