/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.data.client;

import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.silentchaos512.gems.block.GemLampBlock;
import net.silentchaos512.gems.setup.GemsBlocks;
import net.silentchaos512.gems.util.Gems;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.lib.util.NameUtils;

public class GemsBlockStateProvider
extends BlockStateProvider {
    public GemsBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "silentgems", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ResourceLocation flowerPotCross = this.mcLoc("block/flower_pot_cross");
        for (Gems gem : Gems.values()) {
            this.simpleBlock((Block)gem.getOre());
            this.simpleBlock((Block)gem.getDeepslateOre());
            this.simpleBlock((Block)gem.getNetherOre());
            this.simpleBlock((Block)gem.getEndOre());
            this.simpleBlock(gem.getBlock());
            this.simpleBlock(gem.getBricks());
            this.simpleBlock((Block)gem.getGlass());
            for (GemLampBlock.State state : GemLampBlock.State.values()) {
                this.simpleBlock(gem.getLamp(state), "block/" + gem.getName() + "_lamp" + (state.lit() ? "_on" : ""));
            }
            String glowroseName = gem.getName() + "_glowrose";
            this.simpleBlock((Block)gem.getGlowrose(), (ModelFile)this.models().cross(glowroseName, this.modLoc("block/" + glowroseName)));
            this.simpleBlock((Block)gem.getPottedGlowrose(), (ModelFile)((BlockModelBuilder)this.models().withExistingParent(NameUtils.fromBlock((Block)gem.getPottedGlowrose()).m_135815_(), flowerPotCross)).texture("plant", this.modLoc("block/" + glowroseName)));
        }
        this.simpleBlock((IBlockProvider)GemsBlocks.SILVER_BLOCK);
        this.simpleBlock((IBlockProvider)GemsBlocks.DEEPSLATE_SILVER_ORE);
        this.simpleBlock((IBlockProvider)GemsBlocks.SILVER_ORE);
    }

    private void simpleBlock(IBlockProvider block) {
        this.simpleBlock(block.asBlock());
    }

    private void simpleBlock(IBlockProvider block, String texture) {
        this.simpleBlock(block.asBlock(), texture);
    }

    private void simpleBlock(Block block, String texture) {
        String name = NameUtils.fromBlock((Block)block).m_135815_();
        this.simpleBlock(block, (ModelFile)this.models().cubeAll(name, this.modLoc(texture)));
    }
}

